/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.Objects;

public class DoubleRange {
    public static final String SEPARATOR = ":";
    private final double min;
    private final double max;

    private DoubleRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleRange other = (DoubleRange)obj;
        return Double.doubleToLongBits(this.max) == Double.doubleToLongBits(other.max) && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
    }

    public String toString() {
        if (this.min == this.max) {
            return String.valueOf(this.min);
        }
        return this.min + SEPARATOR + this.max;
    }

    public static DoubleRange is(double value) {
        return new DoubleRange(value, value);
    }

    public static DoubleRange between(double min, double max) {
        return new DoubleRange(min, max);
    }
}

