/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.Objects;

public class IntRange {
    public static final String SEPARATOR = ":";
    private final int min;
    private final int max;

    private IntRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntRange other = (IntRange)obj;
        return this.max == other.max && this.min == other.min;
    }

    public String toString() {
        if (this.min == this.max) {
            return String.valueOf(this.min);
        }
        return this.min + SEPARATOR + this.max;
    }

    public static IntRange is(int value) {
        return new IntRange(value, value);
    }

    public static IntRange between(int min, int max) {
        return new IntRange(min, max);
    }
}

