/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class OrPredicate<T>
implements Predicate<T> {
    private final List<? extends Predicate<? super T>> components;

    public OrPredicate(List<? extends Predicate<? super T>> components) {
        this.components = components;
    }

    @Override
    public boolean test(T t) {
        for (Predicate<T> component : this.components) {
            if (!component.test(t)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> OrPredicate<T> of(Predicate<T> ... components) {
        return new OrPredicate<T>(Arrays.asList(components));
    }
}

