/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.Assert;

public interface Utils {
    public static final String METRICS_PREFIX = "spring.batch.redis.";

    public static <T extends Collection<?>> T createGaugeCollectionSize(String name, T collection, Tag ... tags) {
        return (T)Metrics.globalRegistry.gaugeCollectionSize(METRICS_PREFIX + name, Arrays.asList(tags), collection);
    }

    public static void assertPositive(Duration duration, String name) {
        Assert.notNull((Object)duration, (String)(name + " must not be null"));
        Assert.isTrue((!duration.isZero() ? 1 : 0) != 0, (String)(name + " must not be zero"));
        Assert.isTrue((!duration.isNegative() ? 1 : 0) != 0, (String)(name + " must not be negative"));
    }

    public static void assertPositive(Number value, String name) {
        Assert.notNull((Object)value, (String)(name + " must not be null"));
        Assert.isTrue((value.doubleValue() > 0.0 ? 1 : 0) != 0, (String)(name + " must be greater than zero"));
    }

    public static <K, V, T> T sync(StatefulConnection<K, V> connection) {
        if (connection instanceof StatefulRedisClusterConnection) {
            return (T)((StatefulRedisClusterConnection)connection).sync();
        }
        return (T)((StatefulRedisConnection)connection).sync();
    }

    public static <K, V, T> T async(StatefulConnection<K, V> connection) {
        if (connection instanceof StatefulRedisClusterConnection) {
            return (T)((StatefulRedisClusterConnection)connection).async();
        }
        return (T)((StatefulRedisConnection)connection).async();
    }
}

