/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.convert;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MapFlattener
implements Converter<Map<String, Object>, Map<String, String>>,
ItemProcessor<Map<String, Object>, Map<String, String>> {
    public Map<String, String> process(Map<String, Object> item) {
        return this.convert(item);
    }

    public Map<String, String> convert(Map<String, Object> source) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        this.flatten("", source.entrySet().iterator(), resultMap);
        return resultMap;
    }

    private void flatten(String prefix, Iterator<? extends Map.Entry<String, Object>> map, Map<String, String> flatMap) {
        String actualPrefix;
        String string = actualPrefix = StringUtils.hasText((String)prefix) ? prefix.concat(".") : prefix;
        while (map.hasNext()) {
            Map.Entry<String, Object> element = map.next();
            this.flattenElement(actualPrefix.concat(element.getKey()), element.getValue(), flatMap);
        }
    }

    private void flattenElement(String propertyPrefix, @Nullable Object source, Map<String, String> flatMap) {
        if (source == null) {
            return;
        }
        if (source instanceof Iterable) {
            int counter = 0;
            for (Object element : (Iterable)source) {
                this.flattenElement(propertyPrefix + "[" + counter + "]", element, flatMap);
                ++counter;
            }
        } else if (source instanceof Map) {
            this.flatten(propertyPrefix, ((Map)source).entrySet().iterator(), flatMap);
        } else {
            flatMap.put(propertyPrefix, String.valueOf(source));
        }
    }
}

