/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.convert;

import com.redis.lettucemod.timeseries.Sample;
import org.springframework.core.convert.converter.Converter;

public class SampleConverter<T>
implements Converter<T, Sample> {
    private final Converter<T, Long> timestampConverter;
    private final Converter<T, Double> valueConverter;

    public SampleConverter(Converter<T, Long> timestamp, Converter<T, Double> value) {
        this.timestampConverter = timestamp;
        this.valueConverter = value;
    }

    public Sample convert(T source) {
        Double value = (Double)this.valueConverter.convert(source);
        if (value == null) {
            return null;
        }
        Long timestamp = (Long)this.timestampConverter.convert(source);
        if (timestamp == null) {
            timestamp = 0L;
        }
        return Sample.of((long)timestamp, (double)value);
    }
}

