/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.convert;

import io.lettuce.core.ScoredValue;
import org.springframework.core.convert.converter.Converter;

public class ScoredValueConverter<V, T>
implements Converter<T, ScoredValue<V>> {
    private final Converter<T, V> memberConverter;
    private final Converter<T, Double> scoreConverter;

    public ScoredValueConverter(Converter<T, V> member, Converter<T, Double> score) {
        this.memberConverter = member;
        this.scoreConverter = score;
    }

    public ScoredValue<V> convert(T source) {
        Double score = (Double)this.scoreConverter.convert(source);
        if (score == null) {
            return null;
        }
        return ScoredValue.just((double)score, (Object)this.memberConverter.convert(source));
    }
}

