/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.Utils;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractValueReader<K, V, T>
extends ItemStreamSupport
implements ItemProcessor<List<? extends K>, List<T>> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String ABSTTL_LUA = "absttl.lua";
    private final GenericObjectPool<StatefulConnection<K, V>> connectionPool;
    private String digest;

    protected AbstractValueReader(GenericObjectPool<StatefulConnection<K, V>> connectionPool) {
        Assert.notNull(connectionPool, (String)"Right connection pool is required");
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
        this.connectionPool = connectionPool;
    }

    public synchronized void open(ExecutionContext executionContext) {
        super.open(executionContext);
        if (this.digest == null) {
            byte[] bytes;
            try (InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ABSTTL_LUA);){
                bytes = FileCopyUtils.copyToByteArray((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not load LUA script file absttl.lua");
            }
            try (StatefulConnection connection = (StatefulConnection)this.connectionPool.borrowObject();){
                RedisScriptingAsyncCommands commands = (RedisScriptingAsyncCommands)Utils.async(connection);
                RedisFuture future = commands.scriptLoad(bytes);
                this.digest = (String)future.get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"Interrupted!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new ItemStreamException("Could not open reader", (Throwable)e);
            }
        }
    }

    protected RedisFuture<Long> absoluteTTL(BaseRedisAsyncCommands<K, V> commands, K ... keys) {
        return ((RedisScriptingAsyncCommands)commands).evalsha(this.digest, ScriptOutputType.INTEGER, (Object[])keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> process(List<? extends K> item) throws Exception {
        try (StatefulConnection connection = (StatefulConnection)this.connectionPool.borrowObject();){
            List<T> list;
            connection.setAutoFlushCommands(false);
            try {
                list = this.read(connection, item);
            }
            catch (Throwable throwable) {
                connection.setAutoFlushCommands(true);
                throw throwable;
            }
            connection.setAutoFlushCommands(true);
            return list;
        }
    }

    protected abstract List<T> read(StatefulConnection<K, V> var1, List<? extends K> var2) throws Exception;
}

