/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.common.DataStructure;
import com.redis.spring.batch.common.DoubleRange;
import com.redis.spring.batch.common.IntRange;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DataStructureGeneratorItemReader
extends AbstractItemCountingItemStreamItemReader<DataStructure<String>> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final int LEFT_LIMIT = 48;
    private static final int RIGHT_LIMIT = 122;
    public static final String DEFAULT_KEYSPACE = "gen";
    public static final int DEFAULT_MAX_ITEM_COUNT = 100;
    public static final IntRange DEFAULT_HASH_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_HASH_FIELD_SIZE = IntRange.is(100);
    public static final IntRange DEFAULT_STREAM_FIELD_COUNT = IntRange.is(10);
    public static final IntRange DEFAULT_STREAM_FIELD_SIZE = IntRange.is(100);
    public static final IntRange DEFAULT_JSON_FIELD_COUNT = IntRange.is(10);
    public static final IntRange DEFAULT_JSON_FIELD_SIZE = IntRange.is(100);
    public static final IntRange DEFAULT_TIMESERIES_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_STREAM_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_ZSET_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_SET_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_LIST_SIZE = IntRange.is(10);
    public static final IntRange DEFAULT_STRING_SIZE = IntRange.is(100);
    public static final DoubleRange DEFAULT_ZSET_SCORE = DoubleRange.between(0.0, 100.0);
    private static final List<DataStructure.Type> DEFAULT_TYPES = Arrays.asList(DataStructure.Type.HASH, DataStructure.Type.LIST, DataStructure.Type.SET, DataStructure.Type.STREAM, DataStructure.Type.STRING, DataStructure.Type.ZSET);
    private final ObjectMapper mapper = new ObjectMapper();
    private Optional<IntRange> expiration = Optional.empty();
    private IntRange hashSize = DEFAULT_HASH_SIZE;
    private IntRange hashFieldSize = DEFAULT_HASH_FIELD_SIZE;
    private IntRange streamFieldCount = DEFAULT_STREAM_FIELD_COUNT;
    private IntRange streamFieldSize = DEFAULT_STREAM_FIELD_SIZE;
    private IntRange jsonFieldCount = DEFAULT_JSON_FIELD_COUNT;
    private IntRange jsonFieldSize = DEFAULT_JSON_FIELD_SIZE;
    private IntRange timeseriesSize = DEFAULT_TIMESERIES_SIZE;
    private IntRange streamSize = DEFAULT_STREAM_SIZE;
    private IntRange listSize = DEFAULT_LIST_SIZE;
    private IntRange setSize = DEFAULT_SET_SIZE;
    private IntRange zsetSize = DEFAULT_ZSET_SIZE;
    private IntRange stringSize = DEFAULT_STRING_SIZE;
    private DoubleRange zsetScore = DEFAULT_ZSET_SCORE;
    private String keyspace = "gen";
    private final Random random = new Random();
    private List<DataStructure.Type> types = DEFAULT_TYPES;
    private long timeseriesStartTime;

    public DataStructureGeneratorItemReader() {
    }

    private DataStructureGeneratorItemReader(Builder builder) {
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
        this.setSaveState(builder.saveState);
        this.setCurrentItemCount(builder.currentItemCount);
        this.setMaxItemCount(builder.maxItemCount);
        this.keyspace = builder.keyspace;
        this.types = builder.types;
        this.expiration = builder.expiration;
        this.hashSize = builder.hashSize;
        this.hashFieldSize = builder.hashFieldSize;
        this.streamFieldCount = builder.streamFieldCount;
        this.streamFieldSize = builder.streamFieldSize;
        this.jsonFieldCount = builder.jsonFieldCount;
        this.jsonFieldSize = builder.jsonFieldSize;
        this.setSize = builder.setSize;
        this.streamSize = builder.streamSize;
        this.zsetSize = builder.zsetSize;
        this.listSize = builder.listSize;
        this.timeseriesStartTime = builder.timeseriesStartTime;
        this.timeseriesSize = builder.timeseriesSize;
        this.stringSize = builder.stringSize;
        this.zsetScore = builder.zsetScore;
    }

    public String key() {
        return this.keyspace + ":" + this.getCurrentItemCount();
    }

    private Object value(DataStructure.Type type) {
        switch (type) {
            case HASH: {
                return this.map(this.hashSize, this.hashFieldSize);
            }
            case LIST: {
                return this.members(this.listSize);
            }
            case SET: {
                return new HashSet<String>(this.members(this.setSize));
            }
            case STREAM: {
                return this.streamMessages();
            }
            case STRING: {
                return this.string(this.stringSize);
            }
            case ZSET: {
                return this.zset();
            }
            case JSON: {
                try {
                    return this.mapper.writeValueAsString(this.map(this.jsonFieldCount, this.jsonFieldSize));
                }
                catch (JsonProcessingException e) {
                    this.log.error((Object)"Could not serialize object to JSON", (Throwable)e);
                    return null;
                }
            }
            case TIMESERIES: {
                return this.samples();
            }
            case NONE: 
            case UNKNOWN: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type));
    }

    private List<Sample> samples() {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        int size = this.randomInt(this.timeseriesSize);
        for (int index = 0; index < size; ++index) {
            samples.add(Sample.of((long)(this.timeseriesStartTime + (long)this.index() + (long)index), (double)this.random.nextDouble()));
        }
        return samples;
    }

    private List<ScoredValue<String>> zset() {
        return this.members(this.zsetSize).stream().map(m -> ScoredValue.just((double)this.randomDouble(this.zsetScore), (Object)m)).collect(Collectors.toList());
    }

    private Collection<StreamMessage<String, String>> streamMessages() {
        String key = this.key();
        ArrayList<StreamMessage<String, String>> messages = new ArrayList<StreamMessage<String, String>>();
        for (int elementIndex = 0; elementIndex < this.randomInt(this.streamSize); ++elementIndex) {
            messages.add((StreamMessage<String, String>)new StreamMessage((Object)key, null, this.map(this.streamFieldCount, this.streamFieldSize)));
        }
        return messages;
    }

    public Map<String, String> map(IntRange fieldCount, IntRange fieldSize) {
        HashMap<String, String> hash = new HashMap<String, String>();
        for (int index = 0; index < this.randomInt(fieldCount); ++index) {
            int fieldIndex = index + 1;
            hash.put("field" + fieldIndex, this.string(fieldSize));
        }
        return hash;
    }

    private String string(IntRange range) {
        int length = range.getMin() + this.random.nextInt(range.getMax() - range.getMin() + 1);
        return this.random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private List<String> members(IntRange size) {
        ArrayList<String> members = new ArrayList<String>();
        for (int index = 0; index < this.randomInt(size); ++index) {
            members.add(String.valueOf(index));
        }
        return members;
    }

    private int randomInt(IntRange range) {
        if (range.getMin() == range.getMax()) {
            return range.getMin();
        }
        return ThreadLocalRandom.current().nextInt(range.getMin(), range.getMax());
    }

    private double randomDouble(DoubleRange range) {
        if (range.getMin() == range.getMax()) {
            return range.getMin();
        }
        return ThreadLocalRandom.current().nextDouble(range.getMin(), range.getMax());
    }

    protected DataStructure<String> doRead() throws Exception {
        DataStructure<String> ds = new DataStructure<String>();
        DataStructure.Type type = this.types.get(this.index() % this.types.size());
        ds.setType(type);
        ds.setKey(this.key());
        ds.setValue(this.value(type));
        this.expiration.ifPresent(e -> ds.setTtl(System.currentTimeMillis() + (long)this.randomInt((IntRange)e)));
        return ds;
    }

    private int index() {
        return this.getCurrentItemCount() - 1;
    }

    protected void doOpen() throws Exception {
    }

    protected void doClose() throws Exception {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<DataStructure.Type> defaultTypes() {
        return DEFAULT_TYPES;
    }

    static /* synthetic */ List access$2000() {
        return DEFAULT_TYPES;
    }

    public static class Builder {
        private String keyspace = "gen";
        private List<DataStructure.Type> types = DataStructureGeneratorItemReader.access$2000();
        private boolean saveState;
        private int currentItemCount;
        private int maxItemCount = 100;
        private Optional<IntRange> expiration = Optional.empty();
        private IntRange hashSize = DEFAULT_HASH_SIZE;
        private IntRange hashFieldSize = DEFAULT_HASH_FIELD_SIZE;
        private IntRange streamFieldCount = DEFAULT_STREAM_FIELD_COUNT;
        private IntRange streamFieldSize = DEFAULT_STREAM_FIELD_SIZE;
        private IntRange jsonFieldCount = DEFAULT_JSON_FIELD_COUNT;
        private IntRange jsonFieldSize = DEFAULT_JSON_FIELD_SIZE;
        private IntRange streamSize = DEFAULT_STREAM_SIZE;
        private IntRange timeseriesSize = DEFAULT_TIMESERIES_SIZE;
        private IntRange setSize = DEFAULT_SET_SIZE;
        private IntRange zsetSize = DEFAULT_ZSET_SIZE;
        private IntRange listSize = DEFAULT_LIST_SIZE;
        private IntRange stringSize = DEFAULT_STRING_SIZE;
        private DoubleRange zsetScore = DEFAULT_ZSET_SCORE;
        private long timeseriesStartTime;

        public Builder keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder saveState(boolean saveState) {
            this.saveState = saveState;
            return this;
        }

        public Builder timeseriesStartTime(long time) {
            Assert.isTrue((time >= 0L ? 1 : 0) != 0, (String)"Time must be positive");
            this.timeseriesStartTime = time;
            return this;
        }

        public Builder currentItemCount(int count) {
            this.currentItemCount = count;
            return this;
        }

        public Builder maxItemCount(int count) {
            this.maxItemCount = count;
            return this;
        }

        public Builder expiration(IntRange expiration) {
            this.expiration = Optional.of(expiration);
            return this;
        }

        public Builder hashSize(IntRange size) {
            this.hashSize = size;
            return this;
        }

        public Builder hashFieldSize(IntRange hashFieldSize) {
            this.hashFieldSize = hashFieldSize;
            return this;
        }

        public Builder streamFieldCount(IntRange streamFieldCount) {
            this.streamFieldCount = streamFieldCount;
            return this;
        }

        public Builder streamFieldSize(IntRange streamFieldSize) {
            this.streamFieldSize = streamFieldSize;
            return this;
        }

        public Builder jsonFieldCount(IntRange jsonFieldCount) {
            this.jsonFieldCount = jsonFieldCount;
            return this;
        }

        public Builder jsonFieldSize(IntRange jsonFieldSize) {
            this.jsonFieldSize = jsonFieldSize;
            return this;
        }

        public Builder setSize(IntRange size) {
            this.setSize = size;
            return this;
        }

        public Builder zsetSize(IntRange size) {
            this.zsetSize = size;
            return this;
        }

        public Builder streamSize(IntRange size) {
            this.streamSize = size;
            return this;
        }

        public Builder listSize(IntRange size) {
            this.listSize = size;
            return this;
        }

        public Builder timeseriesSize(IntRange size) {
            this.timeseriesSize = size;
            return this;
        }

        public Builder stringSize(IntRange stringSize) {
            this.stringSize = stringSize;
            return this;
        }

        public Builder zsetScore(DoubleRange zsetScore) {
            this.zsetScore = zsetScore;
            return this;
        }

        public Builder types(DataStructure.Type ... types) {
            this.types = Arrays.asList(types);
            return this;
        }

        public DataStructureGeneratorItemReader build() {
            return new DataStructureGeneratorItemReader(this);
        }
    }
}

