/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.lettucemod.api.async.RedisJSONAsyncCommands;
import com.redis.lettucemod.api.async.RedisTimeSeriesAsyncCommands;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.TimeRange;
import com.redis.spring.batch.common.DataStructure;
import com.redis.spring.batch.common.Utils;
import com.redis.spring.batch.reader.AbstractValueReader;
import io.lettuce.core.Range;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisListAsyncCommands;
import io.lettuce.core.api.async.RedisSetAsyncCommands;
import io.lettuce.core.api.async.RedisSortedSetAsyncCommands;
import io.lettuce.core.api.async.RedisStreamAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class DataStructureValueReader<K, V>
extends AbstractValueReader<K, V, DataStructure<K>> {
    private static final TimeRange TIME_RANGE = TimeRange.unbounded();
    private static final RangeOptions RANGE_OPTIONS = RangeOptions.builder().build();
    private static final Range<String> XRANGE = Range.create((Object)"-", (Object)"+");

    public DataStructureValueReader(GenericObjectPool<StatefulConnection<K, V>> pool) {
        super(pool);
    }

    @Override
    protected List<DataStructure<K>> read(StatefulConnection<K, V> connection, List<? extends K> keys) throws InterruptedException, ExecutionException, TimeoutException {
        int index;
        BaseRedisAsyncCommands commands = (BaseRedisAsyncCommands)Utils.async(connection);
        ArrayList<RedisFuture> typeFutures = new ArrayList<RedisFuture>(keys.size());
        for (K key : keys) {
            typeFutures.add(((RedisKeyAsyncCommands)commands).type(key));
        }
        connection.flushCommands();
        ArrayList<DataStructure<K>> dataStructures = new ArrayList<DataStructure<K>>(keys.size());
        ArrayList<RedisFuture<Long>> ttlFutures = new ArrayList<RedisFuture<Long>>(keys.size());
        ArrayList valueFutures = new ArrayList(keys.size());
        for (index = 0; index < keys.size(); ++index) {
            K key = keys.get(index);
            String type = (String)((RedisFuture)typeFutures.get(index)).get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            valueFutures.add(this.value(commands, key, type));
            ttlFutures.add(this.absoluteTTL(commands, key));
            DataStructure<K> dataStructure = new DataStructure<K>();
            dataStructure.setKey(key);
            dataStructure.setTypeString(type);
            dataStructures.add(dataStructure);
        }
        connection.flushCommands();
        for (index = 0; index < dataStructures.size(); ++index) {
            Object value;
            DataStructure dataStructure = (DataStructure)dataStructures.get(index);
            RedisFuture valueFuture = (RedisFuture)valueFutures.get(index);
            if (valueFuture != null && (value = valueFuture.get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS)) != null) {
                this.setValue(dataStructure, value);
            }
            long absoluteTTL = (Long)((RedisFuture)ttlFutures.get(index)).get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            dataStructure.setTtl(absoluteTTL);
        }
        return dataStructures;
    }

    protected void setValue(DataStructure<K> dataStructure, Object value) {
        dataStructure.setValue(value);
    }

    private RedisFuture<?> value(BaseRedisAsyncCommands<K, V> commands, K key, String typeName) {
        DataStructure.Type type = DataStructure.Type.of(typeName);
        if (type == null) {
            return null;
        }
        switch (type) {
            case HASH: {
                return ((RedisHashAsyncCommands)commands).hgetall(key);
            }
            case LIST: {
                return ((RedisListAsyncCommands)commands).lrange(key, 0L, -1L);
            }
            case SET: {
                return ((RedisSetAsyncCommands)commands).smembers(key);
            }
            case STREAM: {
                return ((RedisStreamAsyncCommands)commands).xrange(key, XRANGE);
            }
            case STRING: {
                return ((RedisStringAsyncCommands)commands).get(key);
            }
            case ZSET: {
                return ((RedisSortedSetAsyncCommands)commands).zrangeWithScores(key, 0L, -1L);
            }
            case JSON: {
                return ((RedisJSONAsyncCommands)commands).jsonGet(key, new Object[0]);
            }
            case TIMESERIES: {
                return ((RedisTimeSeriesAsyncCommands)commands).tsRange(key, TIME_RANGE, RANGE_OPTIONS);
            }
        }
        return null;
    }
}

