/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.DataStructure;
import com.redis.spring.batch.reader.AbstractValueReader;
import com.redis.spring.batch.reader.DataStructureValueReader;
import com.redis.spring.batch.reader.KeyComparison;
import io.lettuce.core.api.StatefulConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class KeyComparisonValueReader
extends AbstractValueReader<String, String, KeyComparison<String>> {
    private final DataStructureValueReader<String, String> left;
    private final DataStructureValueReader<String, String> right;
    private final long ttlToleranceMillis;

    public KeyComparisonValueReader(GenericObjectPool<StatefulConnection<String, String>> left, GenericObjectPool<StatefulConnection<String, String>> right, Duration ttlTolerance) {
        super(left);
        Assert.notNull(right, (String)"Right connection pool is required");
        this.left = new DataStructureValueReader<String, String>(left);
        this.right = new DataStructureValueReader<String, String>(right);
        this.ttlToleranceMillis = ttlTolerance.toMillis();
    }

    @Override
    public synchronized void open(ExecutionContext executionContext) {
        this.right.open(executionContext);
        this.left.open(executionContext);
        super.open(executionContext);
    }

    public void close() {
        super.close();
        this.left.close();
        this.right.close();
    }

    @Override
    protected List<KeyComparison<String>> read(StatefulConnection<String, String> connection, List<? extends String> keys) throws Exception {
        ArrayList<KeyComparison<String>> comparisons = new ArrayList<KeyComparison<String>>();
        List sourceItems = this.left.process(keys);
        List targetItems = this.right.process(keys);
        Assert.isTrue((targetItems != null && targetItems.size() == keys.size() ? 1 : 0) != 0, (String)"Missing values in value reader response");
        for (int index = 0; index < keys.size(); ++index) {
            DataStructure source = (DataStructure)sourceItems.get(index);
            DataStructure target = (DataStructure)targetItems.get(index);
            comparisons.add(new KeyComparison(source, target, this.compare(source, target)));
        }
        return comparisons;
    }

    private KeyComparison.Status compare(DataStructure<String> source, DataStructure<String> target) {
        if (!Objects.equals((Object)source.getType(), (Object)target.getType())) {
            if (target.getType() == DataStructure.Type.NONE) {
                return KeyComparison.Status.MISSING;
            }
            return KeyComparison.Status.TYPE;
        }
        if (!Objects.deepEquals(source.getValue(), target.getValue())) {
            return KeyComparison.Status.VALUE;
        }
        if (!this.ttlEquals(source.getTtl(), target.getTtl())) {
            return KeyComparison.Status.TTL;
        }
        return KeyComparison.Status.OK;
    }

    private boolean ttlEquals(Long source, Long target) {
        if (source == null) {
            return target == null;
        }
        if (target == null) {
            return false;
        }
        return Math.abs(source - target) <= this.ttlToleranceMillis;
    }

    public static Builder comparator(GenericObjectPool<StatefulConnection<String, String>> left, GenericObjectPool<StatefulConnection<String, String>> right) {
        return new Builder(left, right);
    }

    public static class Builder {
        private static final Duration DEFAULT_TTL_TOLERANCE = Duration.ofMillis(100L);
        private final GenericObjectPool<StatefulConnection<String, String>> leftConnectionPool;
        private final GenericObjectPool<StatefulConnection<String, String>> rightConnectionPool;
        private Duration ttlTolerance = DEFAULT_TTL_TOLERANCE;

        public Builder(GenericObjectPool<StatefulConnection<String, String>> left, GenericObjectPool<StatefulConnection<String, String>> right) {
            this.leftConnectionPool = left;
            this.rightConnectionPool = right;
        }

        public Builder ttlTolerance(Duration ttlTolerance) {
            this.ttlTolerance = ttlTolerance;
            return this;
        }

        public KeyComparisonValueReader build() {
            return new KeyComparisonValueReader(this.leftConnectionPool, this.rightConnectionPool, this.ttlTolerance);
        }
    }
}

