/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.KeyDump;
import com.redis.spring.batch.common.Utils;
import com.redis.spring.batch.reader.AbstractValueReader;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class KeyDumpValueReader<K, V>
extends AbstractValueReader<K, V, KeyDump<K>> {
    public KeyDumpValueReader(GenericObjectPool<StatefulConnection<K, V>> pool) {
        super(pool);
    }

    @Override
    protected List<KeyDump<K>> read(StatefulConnection<K, V> connection, List<? extends K> keys) throws InterruptedException, ExecutionException, TimeoutException {
        BaseRedisAsyncCommands commands = (BaseRedisAsyncCommands)Utils.async(connection);
        ArrayList<RedisFuture<Long>> ttlFutures = new ArrayList<RedisFuture<Long>>(keys.size());
        ArrayList<RedisFuture> dumpFutures = new ArrayList<RedisFuture>(keys.size());
        for (K key : keys) {
            ttlFutures.add(this.absoluteTTL(commands, key));
            dumpFutures.add(((RedisKeyAsyncCommands)commands).dump(key));
        }
        connection.flushCommands();
        ArrayList<KeyDump<K>> keyValueList = new ArrayList<KeyDump<K>>(keys.size());
        long timeout = connection.getTimeout().toMillis();
        for (int index = 0; index < keys.size(); ++index) {
            KeyDump<K> keyValue = new KeyDump<K>();
            keyValue.setKey(keys.get(index));
            keyValue.setDump((byte[])((RedisFuture)dumpFutures.get(index)).get(timeout, TimeUnit.MILLISECONDS));
            keyValue.setTtl((Long)((RedisFuture)ttlFutures.get(index)).get(timeout, TimeUnit.MILLISECONDS));
            keyValueList.add(keyValue);
        }
        return keyValueList;
    }
}

