/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;
import java.util.function.Predicate;

public class KeySlotPredicate<K>
implements Predicate<K> {
    private final RedisCodec<K, ?> codec;
    private final int min;
    private final int max;

    public KeySlotPredicate(RedisCodec<K, ?> codec, int min, int max) {
        this.codec = codec;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(K key) {
        int slot = SlotHash.getSlot((ByteBuffer)this.codec.encodeKey(key));
        return slot < this.min || slot > this.max;
    }

    public static KeySlotPredicate<String> of(int min, int max) {
        return new KeySlotPredicate<String>((RedisCodec<String, ?>)StringCodec.UTF8, min, max);
    }

    public static <K> KeySlotPredicate<K> of(RedisCodec<K, ?> codec, int min, int max) {
        return new KeySlotPredicate<K>(codec, min, max);
    }
}

