/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.JobRunner;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.reader.KeyspaceNotificationItemReader;
import com.redis.spring.batch.reader.KeyspaceNotificationPublisher;
import com.redis.spring.batch.reader.LiveReaderOptions;
import com.redis.spring.batch.reader.LiveRedisItemReader;
import com.redis.spring.batch.reader.RedisClusterKeyspaceNotificationPublisher;
import com.redis.spring.batch.reader.RedisKeyspaceNotificationPublisher;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ObjectUtils;

public class LiveReaderBuilder<K, V, T extends KeyValue<K>> {
    public static final String PUBSUB_PATTERN_FORMAT = "__keyspace@%s__:%s";
    public static final Converter<String, String> STRING_KEY_EXTRACTOR = m -> m.substring(m.indexOf(":") + 1);
    private final JobRunner jobRunner;
    private final ItemProcessor<List<? extends K>, List<T>> valueReader;
    private final StatefulRedisPubSubConnection<K, V> pubSubConnection;
    private final Converter<K, K> keyExtractor;
    private LiveReaderOptions options = LiveReaderOptions.builder().build();
    private final K[] pubSubPatterns;
    private Optional<Predicate<K>> keyFilter = Optional.empty();

    public LiveReaderBuilder(JobRunner jobRunner, ItemProcessor<List<? extends K>, List<T>> valueReader, StatefulRedisPubSubConnection<K, V> pubSubConnection, K[] pubSubPatterns, Converter<K, K> eventKeyExtractor) {
        this.jobRunner = jobRunner;
        this.valueReader = valueReader;
        this.pubSubConnection = pubSubConnection;
        this.pubSubPatterns = pubSubPatterns;
        this.keyExtractor = eventKeyExtractor;
    }

    public LiveReaderBuilder<K, V, T> keyFilter(Predicate<K> keyFilter) {
        this.keyFilter = Optional.of(keyFilter);
        return this;
    }

    public LiveReaderBuilder<K, V, T> options(LiveReaderOptions options) {
        this.options = options;
        return this;
    }

    public LiveRedisItemReader<K, T> build() {
        KeyspaceNotificationItemReader<K> keyReader = new KeyspaceNotificationItemReader<K>(this.keyspaceNotificationPublisher(), this.keyExtractor, this.pubSubPatterns, this.options.getNotificationQueueOptions());
        this.keyFilter.ifPresent(keyReader::setFilter);
        return new LiveRedisItemReader<K, T>(keyReader, this.valueReader, this.jobRunner, this.options);
    }

    private KeyspaceNotificationPublisher<K> keyspaceNotificationPublisher() {
        if (this.pubSubConnection instanceof StatefulRedisClusterPubSubConnection) {
            return new RedisClusterKeyspaceNotificationPublisher((StatefulRedisClusterPubSubConnection)this.pubSubConnection);
        }
        return new RedisKeyspaceNotificationPublisher<K, V>(this.pubSubConnection);
    }

    private static <K> K encodeKey(RedisCodec<K, ?> codec, String key) {
        return (K)codec.decodeKey(StringCodec.UTF8.encodeKey(key));
    }

    private static <K> String decodeKey(RedisCodec<K, ?> codec, K key) {
        return StringCodec.UTF8.decodeKey(codec.encodeKey(key));
    }

    public static <K> Converter<K, K> keyExtractor(RedisCodec<K, ?> codec) {
        return k -> LiveReaderBuilder.encodeKey(codec, (String)STRING_KEY_EXTRACTOR.convert((Object)LiveReaderBuilder.decodeKey(codec, k)));
    }

    public static <K> K[] pubSubPatterns(RedisCodec<K, ?> codec, int database, String ... keyPatterns) {
        return Stream.of(LiveReaderBuilder.pubSubPatterns(database, keyPatterns)).map(s -> LiveReaderBuilder.encodeKey(codec, s)).toArray();
    }

    public static String[] pubSubPatterns(int database, String ... keyPatterns) {
        if (ObjectUtils.isEmpty((Object[])keyPatterns)) {
            return new String[]{LiveReaderBuilder.pubSubPattern(database, "*")};
        }
        String[] patterns = new String[keyPatterns.length];
        for (int index = 0; index < keyPatterns.length; ++index) {
            patterns[index] = LiveReaderBuilder.pubSubPattern(database, keyPatterns[index]);
        }
        return patterns;
    }

    public static String pubSubPattern(int database, String keyPattern) {
        return String.format(PUBSUB_PATTERN_FORMAT, database, keyPattern);
    }
}

