/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.reader.QueueOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.batch.core.step.skip.SkipPolicy;

public class ReaderOptions {
    public static final int DEFAULT_SKIP_LIMIT = 0;
    public static final int DEFAULT_THREADS = 1;
    public static final int DEFAULT_CHUNK_SIZE = 50;
    private int chunkSize = 50;
    private QueueOptions queueOptions = QueueOptions.builder().build();
    private int skipLimit = 0;
    private Optional<SkipPolicy> skipPolicy = Optional.empty();
    private int threads = 1;
    private List<Class<? extends Throwable>> skip = new ArrayList<Class<? extends Throwable>>();
    private List<Class<? extends Throwable>> noSkip = new ArrayList<Class<? extends Throwable>>();

    public ReaderOptions() {
    }

    protected ReaderOptions(Builder<?> builder) {
        this.chunkSize = ((Builder)builder).chunkSize;
        this.queueOptions = ((Builder)builder).queueOptions;
        this.skip = ((Builder)builder).skip;
        this.noSkip = ((Builder)builder).noSkip;
        this.skipLimit = ((Builder)builder).skipLimit;
        this.skipPolicy = ((Builder)builder).skipPolicy;
        this.threads = ((Builder)builder).threads;
    }

    public List<Class<? extends Throwable>> getSkip() {
        return this.skip;
    }

    public void setSkip(List<Class<? extends Throwable>> skip) {
        this.skip = skip;
    }

    public List<Class<? extends Throwable>> getNoSkip() {
        return this.noSkip;
    }

    public void setNoSkip(List<Class<? extends Throwable>> noSkip) {
        this.noSkip = noSkip;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public QueueOptions getQueueOptions() {
        return this.queueOptions;
    }

    public void setQueueOptions(QueueOptions queueOptions) {
        this.queueOptions = queueOptions;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getSkipLimit() {
        return this.skipLimit;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public Optional<SkipPolicy> getSkipPolicy() {
        return this.skipPolicy;
    }

    public void setSkipPolicy(Optional<SkipPolicy> skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public String toString() {
        return "ReaderOptions [chunkSize=" + this.chunkSize + ", queueOptions=" + this.queueOptions + ", skipLimit=" + this.skipLimit + ", skipPolicy=" + this.skipPolicy + ", threads=" + this.threads + ", skip=" + this.skip + ", noSkip=" + this.noSkip + "]";
    }

    public static class Builder<B extends Builder<B>> {
        private int chunkSize = 50;
        private QueueOptions queueOptions = QueueOptions.builder().build();
        private int skipLimit = 0;
        private List<Class<? extends Throwable>> skip = new ArrayList<Class<? extends Throwable>>();
        private List<Class<? extends Throwable>> noSkip = new ArrayList<Class<? extends Throwable>>();
        private Optional<SkipPolicy> skipPolicy = Optional.empty();
        private int threads = 1;

        protected Builder() {
        }

        public B chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return (B)this;
        }

        public B queueOptions(QueueOptions queueOptions) {
            this.queueOptions = queueOptions;
            return (B)this;
        }

        public B skip(Class<? extends Throwable> ... types) {
            return this.skip(Arrays.asList(types));
        }

        public B skip(List<Class<? extends Throwable>> types) {
            this.skip.addAll(types);
            return (B)this;
        }

        public B noSkip(List<Class<? extends Throwable>> types) {
            this.noSkip.addAll(types);
            return (B)this;
        }

        public B noSkip(Class<? extends Throwable> ... types) {
            return this.noSkip(Arrays.asList(types));
        }

        public B skipLimit(int skipLimit) {
            this.skipLimit = skipLimit;
            return (B)this;
        }

        public B skipPolicy(SkipPolicy skipPolicy) {
            return this.skipPolicy(Optional.of(skipPolicy));
        }

        public B skipPolicy(Optional<SkipPolicy> skipPolicy) {
            this.skipPolicy = skipPolicy;
            return (B)this;
        }

        public B threads(int threads) {
            this.threads = threads;
            return (B)this;
        }
    }
}

