/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.reader.KeyspaceNotificationListener;
import com.redis.spring.batch.reader.KeyspaceNotificationPublisher;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class RedisKeyspaceNotificationPublisher<K, V>
extends RedisPubSubAdapter<K, V>
implements KeyspaceNotificationPublisher<K> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final StatefulRedisPubSubConnection<K, V> connection;
    private final List<KeyspaceNotificationListener<K>> listeners = new ArrayList<KeyspaceNotificationListener<K>>();

    public RedisKeyspaceNotificationPublisher(StatefulRedisPubSubConnection<K, V> connection) {
        Assert.notNull(connection, (String)"A pub/sub connection is required");
        this.connection = connection;
    }

    @Override
    public void addListener(KeyspaceNotificationListener<K> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void subscribe(K ... patterns) {
        this.log.debug((Object)"Adding listener");
        this.connection.addListener((RedisPubSubListener)this);
        this.log.debug((Object)"Subscribing to keyspace notifications");
        this.connection.sync().psubscribe((Object[])patterns);
    }

    @Override
    public void unsubscribe(K ... patterns) {
        this.log.debug((Object)"Unsubscribing from keyspace notifications");
        this.connection.sync().punsubscribe((Object[])patterns);
        this.log.debug((Object)"Removing listener");
        this.connection.removeListener((RedisPubSubListener)this);
    }

    private void notification(K notification) {
        this.listeners.forEach(l -> l.notification(notification));
    }

    public void message(K channel, V message) {
        this.notification(channel);
    }

    public void message(K pattern, K channel, V message) {
        this.notification(channel);
    }
}

