/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.common.Utils;
import com.redis.spring.batch.reader.ScanReaderOptions;
import io.lettuce.core.KeyScanArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanIterator;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisKeyCommands;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemStreamItemReader;

public class ScanKeyItemReader<K, V>
extends AbstractItemStreamItemReader<K> {
    private final GenericObjectPool<StatefulConnection<K, V>> connectionPool;
    private final ScanReaderOptions options;
    private ScanIterator<K> scanIterator;

    public ScanKeyItemReader(GenericObjectPool<StatefulConnection<K, V>> connectionPool, ScanReaderOptions options) {
        this.connectionPool = connectionPool;
        this.options = options;
    }

    public synchronized void open(ExecutionContext executionContext) {
        super.open(executionContext);
        if (this.scanIterator == null) {
            KeyScanArgs args = KeyScanArgs.Builder.limit((long)this.options.getCount()).match(this.options.getMatch());
            this.options.getType().ifPresent(arg_0 -> ((KeyScanArgs)args).type(arg_0));
            try (StatefulConnection connection = (StatefulConnection)this.connectionPool.borrowObject();){
                this.scanIterator = ScanIterator.scan((RedisKeyCommands)((RedisKeyCommands)Utils.sync(connection)), (ScanArgs)args);
            }
            catch (Exception e) {
                throw new ItemStreamException("Could not get connection", (Throwable)e);
            }
        }
    }

    public synchronized K read() {
        if (this.scanIterator.hasNext()) {
            return (K)this.scanIterator.next();
        }
        return null;
    }

    public synchronized void close() {
        super.close();
        if (this.scanIterator != null) {
            this.scanIterator = null;
        }
    }
}

