/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.RedisItemReader;
import com.redis.spring.batch.common.JobRunner;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.reader.ScanKeyItemReader;
import com.redis.spring.batch.reader.ScanReaderOptions;
import io.lettuce.core.api.StatefulConnection;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.batch.item.ItemProcessor;

public class ScanReaderBuilder<K, V, T extends KeyValue<K>> {
    private final GenericObjectPool<StatefulConnection<K, V>> connectionPool;
    private final JobRunner jobRunner;
    private final ItemProcessor<List<? extends K>, List<T>> valueReader;
    private ScanReaderOptions options = ScanReaderOptions.builder().build();

    public ScanReaderBuilder(GenericObjectPool<StatefulConnection<K, V>> connectionPool, JobRunner jobRunner, ItemProcessor<List<? extends K>, List<T>> valueReader) {
        this.connectionPool = connectionPool;
        this.jobRunner = jobRunner;
        this.valueReader = valueReader;
    }

    public ScanReaderBuilder<K, V, T> options(ScanReaderOptions options) {
        this.options = options;
        return this;
    }

    public RedisItemReader<K, T> build() {
        return new RedisItemReader<K, T>(this.keyReader(), this.valueReader, this.jobRunner, this.options);
    }

    public ScanKeyItemReader<K, V> keyReader() {
        return new ScanKeyItemReader<K, V>(this.connectionPool, this.options);
    }
}

