/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.hrakaroo.glob.GlobPattern;
import com.hrakaroo.glob.MatchingEngine;
import com.redis.spring.batch.common.Utils;
import com.redis.spring.batch.reader.ScanSizeEstimatorOptions;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisServerAsyncCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.util.Assert;

public class ScanSizeEstimator {
    private static final Logger log = Logger.getLogger(ScanSizeEstimator.class.getName());
    private final GenericObjectPool<StatefulConnection<String, String>> connectionPool;
    private final ScanSizeEstimatorOptions options;

    public ScanSizeEstimator(GenericObjectPool<StatefulConnection<String, String>> connectionPool, ScanSizeEstimatorOptions options) {
        this.connectionPool = connectionPool;
        this.options = options;
    }

    public Long execute() {
        Long l;
        block9: {
            StatefulConnection connection = (StatefulConnection)this.connectionPool.borrowObject();
            try {
                l = this.execute((StatefulConnection<String, String>)connection);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Interrupted!", e);
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            connection.close();
        }
        return l;
    }

    private Long execute(StatefulConnection<String, String> connection) throws InterruptedException, ExecutionException, TimeoutException {
        BaseRedisAsyncCommands commands = (BaseRedisAsyncCommands)Utils.async(connection);
        Long dbsize = (Long)((RedisServerAsyncCommands)commands).dbsize().get();
        if (dbsize == null) {
            return null;
        }
        if (this.options.getMatch().isEmpty() && this.options.getType().isEmpty()) {
            return dbsize;
        }
        double matchRate = this.matchRate(connection, (BaseRedisAsyncCommands<String, String>)commands);
        return Math.round((double)dbsize.longValue() * matchRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double matchRate(StatefulConnection<String, String> connection, BaseRedisAsyncCommands<String, String> commands) throws InterruptedException, ExecutionException, TimeoutException {
        long total = this.options.getSampleSize();
        connection.setAutoFlushCommands(false);
        try {
            ArrayList<RedisFuture> keyFutures = new ArrayList<RedisFuture>();
            int index = 0;
            while ((long)index < total) {
                keyFutures.add(((RedisKeyAsyncCommands)commands).randomkey());
                ++index;
            }
            connection.flushCommands();
            int count = 0;
            HashMap<String, RedisFuture> keyTypeFutures = new HashMap<String, RedisFuture>();
            for (RedisFuture future : keyFutures) {
                String key = (String)future.get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
                if (key == null) continue;
                keyTypeFutures.put(key, this.options.getType().isEmpty() ? null : ((RedisKeyAsyncCommands)commands).type((Object)key));
            }
            connection.flushCommands();
            Predicate<String> matchPredicate = this.matchPredicate();
            for (Map.Entry entry : keyTypeFutures.entrySet()) {
                Optional<String> type;
                if (!matchPredicate.test((String)entry.getKey()) || !(type = this.options.getType()).isEmpty() && !type.get().equalsIgnoreCase((String)((RedisFuture)entry.getValue()).get(connection.getTimeout().toMillis(), TimeUnit.MILLISECONDS))) continue;
                ++count;
            }
            double d = (double)count / (double)total;
            return d;
        }
        finally {
            connection.setAutoFlushCommands(true);
        }
    }

    private Predicate<String> matchPredicate() {
        MatchingEngine engine = GlobPattern.compile((String)this.options.getMatch());
        return arg_0 -> ((MatchingEngine)engine).matches(arg_0);
    }

    public static Builder builder(GenericObjectPool<StatefulConnection<String, String>> connectionPool) {
        return new Builder(connectionPool);
    }

    public static class Builder {
        private final GenericObjectPool<StatefulConnection<String, String>> connectionPool;
        private ScanSizeEstimatorOptions options = ScanSizeEstimatorOptions.builder().build();

        public Builder(GenericObjectPool<StatefulConnection<String, String>> connectionPool) {
            this.connectionPool = connectionPool;
        }

        public Builder options(ScanSizeEstimatorOptions options) {
            Assert.notNull((Object)options, (String)"ScanSizeEstimatorOptions must not be null");
            this.options = options;
            return this;
        }

        public ScanSizeEstimator build() {
            return new ScanSizeEstimator(this.connectionPool, this.options);
        }
    }
}

