/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.reader;

import com.redis.spring.batch.reader.StreamItemReader;
import com.redis.spring.batch.reader.StreamReaderOptions;
import io.lettuce.core.Consumer;
import io.lettuce.core.api.StatefulConnection;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.util.ClassUtils;

public class StreamReaderBuilder<K, V> {
    public static final String DEFAULT_CONSUMER_GROUP = ClassUtils.getShortName(StreamItemReader.class);
    public static final String DEFAULT_CONSUMER = "consumer1";
    private final GenericObjectPool<StatefulConnection<K, V>> connectionPool;
    private final K stream;
    private final Consumer<K> consumer;
    private StreamReaderOptions options = StreamReaderOptions.builder().build();

    public StreamReaderBuilder(GenericObjectPool<StatefulConnection<K, V>> connectionPool, K stream, Consumer<K> consumer) {
        this.connectionPool = connectionPool;
        this.stream = stream;
        this.consumer = consumer;
    }

    public StreamReaderBuilder<K, V> options(StreamReaderOptions options) {
        this.options = options;
        return this;
    }

    public StreamItemReader<K, V> build() {
        return new StreamItemReader<K, V>(this.connectionPool, this.stream, this.consumer, this.options);
    }
}

