/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.reader.PollableItemReader;
import com.redis.spring.batch.step.FlushingOptions;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.metrics.BatchMetrics;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.FaultTolerantChunkProvider;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;
import org.springframework.util.Assert;

public class FlushingChunkProvider<I>
extends FaultTolerantChunkProvider<I> {
    public static final int DEFAULT_MAX_SKIPS_ON_READ = 100;
    private final RepeatOperations repeatOperations;
    private SkipPolicy skipPolicy = new LimitCheckingItemSkipPolicy();
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private int maxSkipsOnRead = 100;
    private FlushingOptions flushingOptions = FlushingOptions.builder().build();
    private long lastActivity = 0L;

    public FlushingChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        super(itemReader, repeatOperations);
        Assert.isTrue((boolean)(itemReader instanceof PollableItemReader), (String)"Reader must extend PollableItemReader");
        this.repeatOperations = repeatOperations;
    }

    public void setMaxSkipsOnRead(int maxSkipsOnRead) {
        this.maxSkipsOnRead = maxSkipsOnRead;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setFlushingOptions(FlushingOptions flushingOptions) {
        this.flushingOptions = flushingOptions;
    }

    private void stopTimer(Timer.Sample sample, StepExecution stepExecution, String status) {
        sample.stop(BatchMetrics.createTimer((String)"item.read", (String)"Item reading duration", (Tag[])new Tag[]{Tag.of((String)"job.name", (String)stepExecution.getJobExecution().getJobInstance().getJobName()), Tag.of((String)"step.name", (String)stepExecution.getStepName()), Tag.of((String)"status", (String)status)}));
    }

    public Chunk<I> provide(StepContribution contribution) {
        long start = System.currentTimeMillis();
        if (this.lastActivity == 0L) {
            this.lastActivity = start;
        }
        Chunk inputs = new Chunk();
        this.repeatOperations.iterate(context -> {
            I item;
            long pollingTimeout = this.flushingOptions.getInterval().toMillis() - (System.currentTimeMillis() - start);
            if (pollingTimeout < 0L) {
                return RepeatStatus.FINISHED;
            }
            Timer.Sample sample = Timer.start((MeterRegistry)Metrics.globalRegistry);
            try {
                item = this.read(contribution, inputs, pollingTimeout);
            }
            catch (SkipOverflowException e) {
                this.stopTimer(sample, contribution.getStepExecution(), "FAILURE");
                return RepeatStatus.FINISHED;
            }
            if (item == null) {
                this.flushingOptions.getTimeout().ifPresent(timeout -> {
                    long idleDuration = System.currentTimeMillis() - this.lastActivity;
                    if (idleDuration > timeout.toMillis()) {
                        inputs.setEnd();
                    }
                });
                return RepeatStatus.CONTINUABLE;
            }
            this.stopTimer(sample, contribution.getStepExecution(), "SUCCESS");
            inputs.add(item);
            contribution.incrementReadCount();
            this.lastActivity = System.currentTimeMillis();
            return RepeatStatus.CONTINUABLE;
        });
        return inputs;
    }

    protected I read(StepContribution contribution, Chunk<I> chunk, long timeout) {
        while (true) {
            try {
                return this.doRead(timeout);
            }
            catch (Exception e) {
                if (this.shouldPolicySkip(this.skipPolicy, e, contribution.getStepSkipCount())) {
                    contribution.incrementReadSkipCount();
                    chunk.skip(e);
                    if (chunk.getErrors().size() >= this.maxSkipsOnRead) {
                        throw new SkipOverflowException("Too many skips on read");
                    }
                    this.logger.debug((Object)"Skipping failed input", (Throwable)e);
                    continue;
                }
                if (Boolean.TRUE.equals(this.rollbackClassifier.classify((Object)e))) {
                    throw new NonSkippableReadException("Non-skippable exception during read", (Throwable)e);
                }
                this.logger.debug((Object)"No-rollback for non-skippable exception (ignored)", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected final I doRead(long timeout) throws Exception {
        try {
            this.getListener().beforeRead();
            Object item = ((PollableItemReader)this.itemReader).poll(timeout, TimeUnit.MILLISECONDS);
            if (item != null) {
                this.getListener().afterRead(item);
            }
            return (I)item;
        }
        catch (Exception e) {
            this.getListener().onReadError(e);
            throw e;
        }
    }

    private boolean shouldPolicySkip(SkipPolicy policy, Throwable e, int skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipPolicyFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }

    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
        for (Exception e : chunk.getErrors()) {
            try {
                this.getListener().onSkipInRead((Throwable)e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, (Throwable)e);
            }
        }
    }
}

