/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.step;

import com.redis.spring.batch.reader.PollableItemReader;
import com.redis.spring.batch.step.FlushingChunkProvider;
import com.redis.spring.batch.step.FlushingOptions;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.classify.Classifier;
import org.springframework.util.Assert;

public class FlushingSimpleStepBuilder<I, O>
extends FaultTolerantStepBuilder<I, O> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FlushingOptions options = FlushingOptions.builder().build();

    public FlushingSimpleStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public FlushingSimpleStepBuilder(SimpleStepBuilder<I, O> parent) {
        super(parent);
    }

    public FlushingSimpleStepBuilder<I, O> chunk(int chunkSize) {
        return (FlushingSimpleStepBuilder)super.chunk(chunkSize);
    }

    public FlushingSimpleStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        return (FlushingSimpleStepBuilder)super.chunk(completionPolicy);
    }

    public FlushingSimpleStepBuilder<I, O> options(FlushingOptions options) {
        this.options = options;
        return this;
    }

    public FlushingSimpleStepBuilder<I, O> faultTolerant() {
        return (FlushingSimpleStepBuilder)super.faultTolerant();
    }

    protected ChunkProvider<I> createChunkProvider() {
        SkipPolicy readSkipPolicy = this.createSkipPolicy();
        readSkipPolicy = this.getFatalExceptionAwareProxy(readSkipPolicy);
        int maxSkipsOnRead = this.maxSkipsOnRead();
        this.log.debug((Object)String.format("Creating chunk provider: maxSkipsOnRead=%s skipPolicy=%s options=%s", maxSkipsOnRead, readSkipPolicy, this.options));
        FlushingChunkProvider chunkProvider = new FlushingChunkProvider(this.getReader(), this.createChunkOperations());
        chunkProvider.setMaxSkipsOnRead(maxSkipsOnRead);
        chunkProvider.setSkipPolicy(readSkipPolicy);
        chunkProvider.setRollbackClassifier((Classifier<Throwable, Boolean>)this.getRollbackClassifier());
        chunkProvider.setFlushingOptions(this.options);
        ArrayList listeners = new ArrayList(this.getItemListeners());
        listeners.addAll(this.getSkipListeners());
        chunkProvider.setListeners(listeners);
        return chunkProvider;
    }

    private int maxSkipsOnRead() {
        return Math.max(this.getChunkSize(), 100);
    }

    public FlushingSimpleStepBuilder<I, O> reader(ItemReader<? extends I> reader) {
        Assert.state((boolean)(reader instanceof PollableItemReader), (String)"Reader must be an instance of PollableItemReader");
        return (FlushingSimpleStepBuilder)super.reader(reader);
    }
}

