/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import com.redis.spring.batch.reader.KeyComparison;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.batch.item.ItemWriter;

public class KeyComparisonCountItemWriter<K>
implements ItemWriter<KeyComparison<K>> {
    private final Results results = new Results();

    public void write(List<? extends KeyComparison<K>> items) throws Exception {
        for (KeyComparison<K> comparison : items) {
            this.results.incrementAndGet(comparison.getStatus());
        }
    }

    public Results getResults() {
        return this.results;
    }

    public static class Results {
        private final Map<KeyComparison.Status, AtomicLong> counts = Stream.of(KeyComparison.Status.values()).collect(Collectors.toMap(s -> s, s -> new AtomicLong()));

        public long incrementAndGet(KeyComparison.Status status) {
            return this.counts.get((Object)status).incrementAndGet();
        }

        public long getCount(KeyComparison.Status status) {
            return this.counts.get((Object)status).get();
        }

        public long getTotalCount() {
            return this.counts.values().stream().collect(Collectors.summingLong(AtomicLong::get));
        }
    }
}

