/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import com.redis.spring.batch.reader.KeyComparison;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class KeyComparisonLogger {
    public static final int INDEX_NOT_FOUND = -1;
    private final Logger log;

    public KeyComparisonLogger() {
        this(Logger.getLogger(KeyComparisonLogger.class.getName()));
    }

    public KeyComparisonLogger(Logger logger) {
        this.log = logger;
    }

    public void log(KeyComparison<String> comparison) {
        block0 : switch (comparison.getStatus()) {
            case MISSING: {
                this.log.log(Level.WARNING, "Missing key {0}", comparison.getSource().getKey());
                break;
            }
            case TTL: {
                this.log.log(Level.WARNING, "TTL mismatch for key {0}: {1} <> {2}", new Object[]{comparison.getSource().getKey(), comparison.getSource().getTtl(), comparison.getTarget().getTtl()});
                break;
            }
            case TYPE: {
                this.log.log(Level.WARNING, "Type mismatch for key {0}: {1} <> {2}", new Object[]{comparison.getSource().getKey(), comparison.getSource().getType(), comparison.getTarget().getType()});
                break;
            }
            case VALUE: {
                switch (comparison.getSource().getType()) {
                    case SET: {
                        this.showSetDiff(comparison);
                        break block0;
                    }
                    case LIST: {
                        this.showListDiff(comparison);
                        break block0;
                    }
                    case ZSET: {
                        this.showSortedSetDiff(comparison);
                        break block0;
                    }
                    case STREAM: {
                        this.showStreamDiff(comparison);
                        break block0;
                    }
                    case STRING: 
                    case JSON: {
                        this.showStringDiff(comparison);
                        break block0;
                    }
                    case HASH: {
                        this.showHashDiff(comparison);
                        break block0;
                    }
                    case TIMESERIES: {
                        this.showListDiff(comparison);
                        break block0;
                    }
                }
                this.log.log(Level.WARNING, "Value mismatch for key '{}'", comparison.getSource().getKey());
                break;
            }
        }
    }

    private void showHashDiff(KeyComparison<String> comparison) {
        Map sourceHash = (Map)comparison.getSource().getValue();
        Map targetHash = (Map)comparison.getTarget().getValue();
        HashMap diff = new HashMap();
        diff.putAll(sourceHash);
        diff.putAll(targetHash);
        diff.entrySet().removeAll(sourceHash.size() <= targetHash.size() ? sourceHash.entrySet() : targetHash.entrySet());
        this.log.log(Level.WARNING, "Value mismatch for hash {0} on fields: {1}", new Object[]{comparison.getSource().getKey(), diff.keySet()});
    }

    private void showStringDiff(KeyComparison<String> comparison) {
        String sourceString = (String)comparison.getSource().getValue();
        String targetString = (String)comparison.getTarget().getValue();
        int diffIndex = KeyComparisonLogger.indexOfDifference(sourceString, targetString);
        this.log.log(Level.WARNING, "Value mismatch for string {0} at offset {1}", new Object[]{comparison.getSource().getKey(), diffIndex});
    }

    private static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        int i;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i = 0; i < cs1.length() && i < cs2.length() && cs1.charAt(i) == cs2.charAt(i); ++i) {
        }
        if (i < cs2.length() || i < cs1.length()) {
            return i;
        }
        return -1;
    }

    private void showListDiff(KeyComparison<String> comparison) {
        List sourceList = (List)comparison.getSource().getValue();
        List targetList = (List)comparison.getTarget().getValue();
        if (sourceList.size() != targetList.size()) {
            this.log.log(Level.WARNING, "Size mismatch for {0} {1}: {2} <> {3}", new Object[]{comparison.getSource().getType(), comparison.getSource().getKey(), sourceList.size(), targetList.size()});
            return;
        }
        ArrayList<Integer> diff = new ArrayList<Integer>();
        for (int index = 0; index < sourceList.size(); ++index) {
            if (sourceList.get(index).equals(targetList.get(index))) continue;
            diff.add(index);
        }
        this.log.log(Level.WARNING, "Value mismatch for {0} {1} at indexes {2}", new Object[]{comparison.getSource().getType(), comparison.getSource().getKey(), diff});
    }

    private void showSetDiff(KeyComparison<String> comparison) {
        Set sourceSet = (Set)comparison.getSource().getValue();
        Set targetSet = (Set)comparison.getTarget().getValue();
        HashSet missing = new HashSet(sourceSet);
        missing.removeAll(targetSet);
        HashSet extra = new HashSet(targetSet);
        extra.removeAll(sourceSet);
        this.log.log(Level.WARNING, "Value mismatch for set {0}: {1} <> {2}", new Object[]{comparison.getSource().getKey(), missing, extra});
    }

    private void showSortedSetDiff(KeyComparison<String> comparison) {
        List sourceList = (List)comparison.getSource().getValue();
        List targetList = (List)comparison.getTarget().getValue();
        ArrayList<ScoredValue<String>> missing = new ArrayList<ScoredValue<String>>(sourceList);
        missing.removeAll(targetList);
        ArrayList<ScoredValue<String>> extra = new ArrayList<ScoredValue<String>>(targetList);
        extra.removeAll(sourceList);
        this.log.log(Level.WARNING, "Value mismatch for sorted set {0}: {1} <> {2}", new Object[]{comparison.getSource().getKey(), this.print(missing), this.print(extra)});
    }

    private List<String> print(List<ScoredValue<String>> list) {
        return list.stream().map(v -> (String)v.getValue() + "@" + v.getScore()).collect(Collectors.toList());
    }

    private void showStreamDiff(KeyComparison<String> comparison) {
        List sourceMessages = (List)comparison.getSource().getValue();
        List targetMessages = (List)comparison.getTarget().getValue();
        ArrayList missing = new ArrayList(sourceMessages);
        missing.removeAll(targetMessages);
        ArrayList extra = new ArrayList(targetMessages);
        extra.removeAll(sourceMessages);
        this.log.log(Level.WARNING, "Value mismatch for stream {0}: {1} <> {2}", new Object[]{comparison.getSource().getKey(), missing.stream().map(StreamMessage::getId).collect(Collectors.toList()), extra.stream().map(StreamMessage::getId).collect(Collectors.toList())});
    }
}

