/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import com.redis.spring.batch.common.Utils;
import com.redis.spring.batch.writer.PipelinedOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisTransactionalAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiExecOperation<K, V, T>
implements PipelinedOperation<K, V, T> {
    private PipelinedOperation<K, V, T> operation;

    public MultiExecOperation(PipelinedOperation<K, V, T> operation) {
        this.operation = operation;
    }

    @Override
    public Collection<RedisFuture<?>> execute(StatefulConnection<K, V> connection, List<? extends T> items) {
        BaseRedisAsyncCommands commands = (BaseRedisAsyncCommands)Utils.async(connection);
        ArrayList futures = new ArrayList();
        futures.add(((RedisTransactionalAsyncCommands)commands).multi());
        futures.addAll(this.operation.execute(connection, items));
        futures.add(((RedisTransactionalAsyncCommands)commands).exec());
        return futures;
    }
}

