/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer;

import com.redis.spring.batch.RedisItemWriter;
import com.redis.spring.batch.writer.MultiExecOperation;
import com.redis.spring.batch.writer.Operation;
import com.redis.spring.batch.writer.PipelinedOperation;
import com.redis.spring.batch.writer.SimplePipelinedOperation;
import com.redis.spring.batch.writer.WaitForReplicationOperation;
import com.redis.spring.batch.writer.WriterOptions;
import io.lettuce.core.api.StatefulConnection;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class WriterBuilder<K, V, T> {
    private final GenericObjectPool<StatefulConnection<K, V>> connectionPool;
    private PipelinedOperation<K, V, T> operation;
    private WriterOptions options = WriterOptions.builder().build();

    public WriterBuilder(GenericObjectPool<StatefulConnection<K, V>> connectionPool, Operation<K, V, T> operation) {
        this(connectionPool, new SimplePipelinedOperation<K, V, T>(operation));
    }

    public WriterBuilder(GenericObjectPool<StatefulConnection<K, V>> connectionPool, PipelinedOperation<K, V, T> operation) {
        this.connectionPool = connectionPool;
        this.operation = operation;
    }

    public WriterBuilder<K, V, T> options(WriterOptions options) {
        this.options = options;
        return this;
    }

    private PipelinedOperation<K, V, T> operation() {
        if (this.options.getWaitForReplication().isPresent()) {
            return new WaitForReplicationOperation<K, V, T>(this.operation, this.options.getWaitForReplication().get());
        }
        return this.operation;
    }

    public RedisItemWriter<K, V, T> build() {
        return new RedisItemWriter(this.connectionPool, this.options.isMultiExec() ? new MultiExecOperation<K, V, T>(this.operation()) : this.operation());
    }
}

