/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public abstract class AbstractCollectionAdd<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Predicate<T> remove;

    protected AbstractCollectionAdd(Converter<T, K> key, Predicate<T> delete, Predicate<T> remove) {
        super(key, delete);
        this.remove = remove;
    }

    @Override
    protected RedisFuture<?> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        if (this.remove.test(item)) {
            return this.remove(commands, item, key);
        }
        return this.add(commands, item, key);
    }

    protected abstract RedisFuture<Long> add(BaseRedisAsyncCommands<K, V> var1, T var2, K var3);

    protected abstract RedisFuture<Long> remove(BaseRedisAsyncCommands<K, V> var1, T var2, K var3);
}

