/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.Operation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;

public abstract class AbstractCollectionAddAll<K, V, T> {
    private final Predicate<T> delPredicate;
    private final Operation<K, V, T> del;

    protected AbstractCollectionAddAll(Predicate<T> delPredicate, Operation<K, V, T> del) {
        this.delPredicate = delPredicate;
        this.del = del;
    }

    public Collection<RedisFuture<?>> execute(BaseRedisAsyncCommands<K, V> commands, T item) {
        ArrayList futures = new ArrayList();
        if (this.delPredicate.test(item)) {
            futures.add(this.del.execute(commands, item));
        }
        futures.addAll(this.doExecute(commands, item));
        return futures;
    }

    protected abstract Collection<RedisFuture<?>> doExecute(BaseRedisAsyncCommands<K, V> var1, T var2);
}

