/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.Operation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Del<K, V, T>
implements Operation<K, V, T> {
    private final Converter<T, K> keyConverter;

    public Del(Converter<T, K> key) {
        Assert.notNull(key, (String)"A key converter is required");
        this.keyConverter = key;
    }

    @Override
    public RedisFuture<Long> execute(BaseRedisAsyncCommands<K, V> commands, T item) {
        Object key = this.keyConverter.convert(item);
        return ((RedisKeyAsyncCommands)commands).del(new Object[]{key});
    }

    public static <K, V, T> Del<K, V, T> of(Converter<T, K> key) {
        return new Del<K, V, T>(key);
    }
}

