/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.Operation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Eval<K, V, T>
implements Operation<K, V, T> {
    private final String sha;
    private final ScriptOutputType output;
    private final Converter<T, K[]> keys;
    private final Converter<T, V[]> args;

    public Eval(String sha, ScriptOutputType output, Converter<T, K[]> keys, Converter<T, V[]> args) {
        Assert.notNull((Object)sha, (String)"A SHA digest is required");
        Assert.notNull((Object)output, (String)"A script output type is required");
        Assert.notNull(keys, (String)"A keys converter is required");
        Assert.notNull(args, (String)"An args converter is required");
        this.sha = sha;
        this.output = output;
        this.keys = keys;
        this.args = args;
    }

    @Override
    public RedisFuture<?> execute(BaseRedisAsyncCommands<K, V> commands, T item) {
        return ((RedisScriptingAsyncCommands)commands).evalsha(this.sha, this.output, (Object[])this.keys.convert(item), (Object[])this.args.convert(item));
    }
}

