/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Expire<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Converter<T, Long> milliseconds;

    public Expire(Converter<T, K> key, Predicate<T> delete, Converter<T, Long> millis) {
        super(key, delete);
        Assert.notNull(millis, (String)"A milliseconds converter is required");
        this.milliseconds = millis;
    }

    @Override
    protected RedisFuture<Boolean> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Long millis = (Long)this.milliseconds.convert(item);
        if (millis == null) {
            return null;
        }
        if (millis < 0L) {
            return null;
        }
        return ((RedisKeyAsyncCommands)commands).pexpire(key, millis.longValue());
    }

    public static <K, T> MillisBuilder<K, T> key(Converter<T, K> key) {
        return new MillisBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Long> millis;

        public Builder(Converter<T, K> key, Converter<T, Long> millis) {
            this.key = key;
            this.millis = millis;
            this.onNull((Converter)millis);
        }

        public Expire<K, V, T> build() {
            return new Expire(this.key, this.del, this.millis);
        }
    }

    public static class MillisBuilder<K, T> {
        private final Converter<T, K> key;

        public MillisBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> millis(Converter<T, Long> millis) {
            return new Builder(this.key, millis);
        }
    }
}

