/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RedisJSONAsyncCommands;
import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.DelBuilder;
import com.redis.spring.batch.writer.operation.JsonDel;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public class JsonSet<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Converter<T, String> path;
    private final Converter<T, V> value;

    public JsonSet(Converter<T, K> key, Predicate<T> delPredicate, Converter<T, String> path, Converter<T, V> value) {
        super(key, delPredicate, new JsonDel(key, path));
        this.path = path;
        this.value = value;
    }

    @Override
    protected RedisFuture<?> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        return ((RedisJSONAsyncCommands)commands).jsonSet(key, (String)this.path.convert(item), this.value.convert(item));
    }

    public static <K, T> ValueBuilder<K, T> key(Converter<T, K> key) {
        return new ValueBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private Converter<T, String> path = t -> "$";
        private final Converter<T, V> value;

        public Builder(Converter<T, K> key, Converter<T, V> value) {
            this.key = key;
            this.value = value;
            this.onNull((Converter)value);
        }

        public Builder<K, V, T> path(String path) {
            this.path = t -> path;
            return this;
        }

        public Builder<K, V, T> path(Converter<T, String> path) {
            this.path = path;
            return this;
        }

        public JsonSet<K, V, T> build() {
            return new JsonSet<K, V, T>(this.key, this.del, this.path, this.value);
        }
    }

    public static class ValueBuilder<K, T> {
        private final Converter<T, K> key;

        public ValueBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> value(Converter<T, V> value) {
            return new Builder<K, V, T>(this.key, value);
        }
    }
}

