/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Restore<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    public static final long TTL_KEY_DOES_NOT_EXIST = -2L;
    private final Converter<T, byte[]> valueConverter;
    private final Converter<T, Long> absoluteTTL;

    public Restore(Converter<T, K> key, Converter<T, byte[]> value, Converter<T, Long> absoluteTTL) {
        super(key, new InexistentKeyPredicate(absoluteTTL));
        Assert.notNull(value, (String)"A value converter is required");
        Assert.notNull(absoluteTTL, (String)"A TTL converter is required");
        this.valueConverter = value;
        this.absoluteTTL = absoluteTTL;
    }

    @Override
    protected RedisFuture<String> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        byte[] value = (byte[])this.valueConverter.convert(item);
        if (value == null) {
            return null;
        }
        return ((RedisKeyAsyncCommands)commands).restore(key, value, this.args(item));
    }

    protected RestoreArgs args(T item) {
        Long ttl = (Long)this.absoluteTTL.convert(item);
        RestoreArgs args = new RestoreArgs();
        if (ttl != null && ttl > 0L) {
            args.absttl();
            args.ttl(ttl.longValue());
        }
        return args;
    }

    private static class InexistentKeyPredicate<T>
    implements Predicate<T> {
        private final Converter<T, Long> absoluteTTL;

        private InexistentKeyPredicate(Converter<T, Long> absoluteTTL) {
            this.absoluteTTL = absoluteTTL;
        }

        @Override
        public boolean test(T t) {
            Long ttl = (Long)this.absoluteTTL.convert(t);
            if (ttl == null) {
                return false;
            }
            return ttl == -2L;
        }
    }
}

