/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisListAsyncCommands;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public class RpushAll<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Converter<T, Collection<V>> members;

    public RpushAll(Converter<T, K> key, Predicate<T> delete, Converter<T, Collection<V>> members) {
        super(key, delete);
        this.members = members;
    }

    @Override
    protected RedisFuture<?> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Collection collection = (Collection)this.members.convert(item);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return ((RedisListAsyncCommands)commands).rpush(key, collection.toArray());
    }

    public static <K, T> MembersBuilder<K, T> key(K key) {
        return RpushAll.key(t -> key);
    }

    public static <K, T> MembersBuilder<K, T> key(Converter<T, K> key) {
        return new MembersBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Collection<V>> members;

        public Builder(Converter<T, K> key, Converter<T, Collection<V>> members) {
            this.key = key;
            this.members = members;
            this.onNull((Converter)members);
        }

        public RpushAll<K, V, T> build() {
            return new RpushAll<K, V, T>(this.key, this.del, this.members);
        }
    }

    public static class MembersBuilder<K, T> {
        private final Converter<T, K> key;

        public MembersBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> members(Converter<T, Collection<V>> members) {
            return new Builder<K, V, T>(this.key, members);
        }
    }
}

