/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractCollectionAdd;
import com.redis.spring.batch.writer.operation.RemoveBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisSetAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public class Sadd<K, V, T>
extends AbstractCollectionAdd<K, V, T> {
    private final Converter<T, V> memberConverter;

    public Sadd(Converter<T, K> key, Predicate<T> delete, Predicate<T> remove, Converter<T, V> member) {
        super(key, delete, remove);
        this.memberConverter = member;
    }

    @Override
    protected RedisFuture<Long> add(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Object member = this.memberConverter.convert(item);
        if (member == null) {
            return null;
        }
        return ((RedisSetAsyncCommands)commands).sadd(key, new Object[]{member});
    }

    @Override
    protected RedisFuture<Long> remove(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Object member = this.memberConverter.convert(item);
        if (member == null) {
            return null;
        }
        return ((RedisSetAsyncCommands)commands).srem(key, new Object[]{member});
    }

    public static <K, T> MemberBuilder<K, T> key(K key) {
        return Sadd.key(t -> key);
    }

    public static <K, T> MemberBuilder<K, T> key(Converter<T, K> key) {
        return new MemberBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends RemoveBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, V> member;

        public Builder(Converter<T, K> key, Converter<T, V> member) {
            this.key = key;
            this.member = member;
            this.onNull((Converter)member);
        }

        public Sadd<K, V, T> build() {
            return new Sadd<K, V, T>(this.key, this.del, this.remove, this.member);
        }
    }

    public static class MemberBuilder<K, T> {
        private final Converter<T, K> key;

        public MemberBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> member(Converter<T, V> member) {
            return new Builder<K, V, T>(this.key, member);
        }
    }
}

