/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.RemoveBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Set<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Converter<T, V> value;
    private final SetArgs args;

    public Set(Converter<T, K> key, Predicate<T> delete, Converter<T, V> value, SetArgs args) {
        super(key, delete);
        Assert.notNull(value, (String)"A value converter is required");
        Assert.notNull((Object)args, (String)"A SetArgs converter is required");
        this.value = value;
        this.args = args;
    }

    @Override
    protected RedisFuture<String> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        return ((RedisStringAsyncCommands)commands).set(key, this.value.convert(item), this.args);
    }

    public static <K, T> ValueBuilder<K, T> key(K key) {
        return Set.key(t -> key);
    }

    public static <K, T> ValueBuilder<K, T> key(Converter<T, K> key) {
        return new ValueBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends RemoveBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, V> member;
        private SetArgs args = new SetArgs();

        public Builder(Converter<T, K> key, Converter<T, V> member) {
            this.key = key;
            this.member = member;
            this.onNull((Converter)member);
        }

        public Builder<K, V, T> args(SetArgs args) {
            this.args = args;
            return this;
        }

        public Set<K, V, T> build() {
            return new Set<K, V, T>(this.key, this.del, this.member, this.args);
        }
    }

    public static class ValueBuilder<K, T> {
        private final Converter<T, K> key;

        public ValueBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> value(Converter<T, V> member) {
            return new Builder<K, V, T>(this.key, member);
        }
    }
}

