/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RediSearchAsyncCommands;
import com.redis.lettucemod.search.Suggestion;
import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Sugadd<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Predicate<T> remove;
    protected final Converter<T, Suggestion<V>> suggestionConverter;
    private final boolean incr;

    public Sugadd(Converter<T, K> key, Predicate<T> remove, Converter<T, Suggestion<V>> suggestion, boolean incr) {
        super(key, t -> false);
        Assert.notNull(remove, (String)"A remove predicate is required");
        Assert.notNull(suggestion, (String)"A suggestion converter is required");
        this.remove = remove;
        this.suggestionConverter = suggestion;
        this.incr = incr;
    }

    @Override
    protected RedisFuture<?> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        if (this.remove.test(item)) {
            return this.remove(commands, item, key);
        }
        return this.add(commands, item, key);
    }

    protected RedisFuture<Long> add(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Suggestion suggestion = (Suggestion)this.suggestionConverter.convert(item);
        if (this.incr) {
            return ((RediSearchAsyncCommands)commands).ftSugaddIncr(key, suggestion);
        }
        return ((RediSearchAsyncCommands)commands).ftSugadd(key, suggestion);
    }

    protected RedisFuture<Boolean> remove(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Suggestion suggestion = (Suggestion)this.suggestionConverter.convert(item);
        if (suggestion == null) {
            return null;
        }
        return ((RediSearchAsyncCommands)commands).ftSugdel(key, suggestion.getString());
    }

    public static <K, T> SuggestionBuilder<K, T> key(K key) {
        return Sugadd.key(t -> key);
    }

    public static <K, T> SuggestionBuilder<K, T> key(Converter<T, K> key) {
        return new SuggestionBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Suggestion<V>> suggestion;
        private boolean increment;

        public Builder(Converter<T, K> key, Converter<T, Suggestion<V>> suggestion) {
            this.key = key;
            this.suggestion = suggestion;
            this.onNull((Converter)suggestion);
        }

        public Builder<K, V, T> increment(boolean increment) {
            this.increment = increment;
            return this;
        }

        public Sugadd<K, V, T> build() {
            return new Sugadd<K, V, T>(this.key, this.del, this.suggestion, this.increment);
        }
    }

    public static class SuggestionBuilder<K, T> {
        private final Converter<T, K> key;

        public SuggestionBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> suggestion(Converter<T, Suggestion<V>> suggestion) {
            return new Builder<K, V, T>(this.key, suggestion);
        }
    }
}

