/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.lettucemod.api.async.RedisTimeSeriesAsyncCommands;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.spring.batch.writer.operation.AbstractCollectionAddAll;
import com.redis.spring.batch.writer.operation.Del;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public class TsAddAll<K, V, T>
extends AbstractCollectionAddAll<K, V, T> {
    private final Converter<T, K> key;
    private final Converter<T, Collection<Sample>> samples;
    private final Converter<Sample, AddOptions<K, V>> options;

    public TsAddAll(Predicate<T> delPredicate, Converter<T, K> key, Converter<T, Collection<Sample>> samples, Converter<Sample, AddOptions<K, V>> options) {
        super(delPredicate, Del.of(key));
        this.key = key;
        this.samples = samples;
        this.options = options;
    }

    @Override
    protected Collection<RedisFuture<?>> doExecute(BaseRedisAsyncCommands<K, V> commands, T item) {
        ArrayList futures = new ArrayList();
        for (Sample sample : (Collection)this.samples.convert(item)) {
            AddOptions addOptions = (AddOptions)this.options.convert((Object)sample);
            futures.add(((RedisTimeSeriesAsyncCommands)commands).tsAdd(this.key.convert(item), sample, addOptions));
        }
        return futures;
    }

    public static <K, T> SamplesBuilder<K, T> key(Converter<T, K> key) {
        return new SamplesBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Collection<Sample>> samples;
        private Converter<Sample, AddOptions<K, V>> options = s -> null;

        public Builder(Converter<T, K> key, Converter<T, Collection<Sample>> samples) {
            this.key = key;
            this.samples = samples;
        }

        public Builder<K, V, T> options(AddOptions<K, V> options) {
            this.options = s -> options;
            return this;
        }

        public Builder<K, V, T> options(Converter<Sample, AddOptions<K, V>> options) {
            this.options = options;
            return this;
        }

        public TsAddAll<K, V, T> build() {
            return new TsAddAll<K, V, T>(this.del, this.key, this.samples, this.options);
        }
    }

    public static class SamplesBuilder<K, T> {
        private final Converter<T, K> key;

        public SamplesBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> samples(Converter<T, Collection<Sample>> samples) {
            return new Builder(this.key, samples);
        }
    }
}

