/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.operation.AbstractKeyOperation;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisStreamAsyncCommands;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Xadd<K, V, T>
extends AbstractKeyOperation<K, V, T> {
    private final Converter<T, XAddArgs> args;
    private final Converter<T, Map<K, V>> body;

    public Xadd(Converter<T, K> key, Predicate<T> delete, Converter<T, Map<K, V>> body, Converter<T, XAddArgs> args) {
        super(key, delete);
        Assert.notNull(body, (String)"A body converter is required");
        Assert.notNull(args, (String)"A XAddArgs converter is required");
        this.body = body;
        this.args = args;
    }

    @Override
    protected RedisFuture<String> doExecute(BaseRedisAsyncCommands<K, V> commands, T item, K key) {
        Map map = (Map)this.body.convert(item);
        if (map.isEmpty()) {
            return null;
        }
        return ((RedisStreamAsyncCommands)commands).xadd(key, (XAddArgs)this.args.convert(item), map);
    }

    public static <K, V> Converter<StreamMessage<K, V>, XAddArgs> identity() {
        return m -> new XAddArgs().id(m.getId());
    }

    public static <K, T> BodyBuilder<K, T> key(K key) {
        return Xadd.key(t -> key);
    }

    public static <K, T> BodyBuilder<K, T> key(Converter<T, K> key) {
        return new BodyBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Map<K, V>> body;
        private Converter<T, XAddArgs> args = t -> null;

        public Builder(Converter<T, K> key, Converter<T, Map<K, V>> body) {
            this.key = key;
            this.body = body;
            this.onNull((Converter)body);
        }

        public Builder<K, V, T> args(XAddArgs args) {
            this.args = t -> args;
            return this;
        }

        public Xadd<K, V, T> build() {
            return new Xadd<K, V, T>(this.key, this.del, this.body, this.args);
        }
    }

    public static class BodyBuilder<K, T> {
        private final Converter<T, K> key;

        public BodyBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> body(Converter<T, Map<K, V>> body) {
            return new Builder<K, V, T>(this.key, body);
        }
    }
}

