/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.writer.operation;

import com.redis.spring.batch.writer.Operation;
import com.redis.spring.batch.writer.operation.AbstractCollectionAddAll;
import com.redis.spring.batch.writer.operation.Del;
import com.redis.spring.batch.writer.operation.DelBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisStreamAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;

public class XaddAll<K, V, T>
extends AbstractCollectionAddAll<K, V, T> {
    private final Converter<T, Collection<StreamMessage<K, V>>> messages;
    private Converter<StreamMessage<K, V>, XAddArgs> args;

    public XaddAll(Predicate<T> delPredicate, Operation<K, V, T> del, Converter<T, Collection<StreamMessage<K, V>>> messages, Converter<StreamMessage<K, V>, XAddArgs> args) {
        super(delPredicate, del);
        this.messages = messages;
        this.args = args;
    }

    public void setArgs(Converter<StreamMessage<K, V>, XAddArgs> args) {
        this.args = args;
    }

    @Override
    protected Collection<RedisFuture<?>> doExecute(BaseRedisAsyncCommands<K, V> commands, T item) {
        ArrayList futures = new ArrayList();
        for (StreamMessage message : (Collection)this.messages.convert(item)) {
            futures.add(((RedisStreamAsyncCommands)commands).xadd(message.getStream(), (XAddArgs)this.args.convert((Object)message), message.getBody()));
        }
        return futures;
    }

    public static <K, T> MessagesBuilder<K, T> key(Converter<T, K> key) {
        return new MessagesBuilder<K, T>(key);
    }

    public static class Builder<K, V, T>
    extends DelBuilder<K, V, T, Builder<K, V, T>> {
        private final Converter<T, K> key;
        private final Converter<T, Collection<StreamMessage<K, V>>> messages;
        private Converter<StreamMessage<K, V>, XAddArgs> args = t -> null;

        public Builder(Converter<T, K> key, Converter<T, Collection<StreamMessage<K, V>>> messages) {
            this.key = key;
            this.messages = messages;
        }

        public Builder<K, V, T> args(XAddArgs args) {
            this.args = t -> args;
            return this;
        }

        public Builder<K, V, T> argsIdentity() {
            this.args = t -> new XAddArgs().id(t.getId());
            return this;
        }

        public XaddAll<K, V, T> build() {
            return new XaddAll(this.del, Del.of(this.key), this.messages, this.args);
        }
    }

    public static class MessagesBuilder<K, T> {
        private final Converter<T, K> key;

        public MessagesBuilder(Converter<T, K> key) {
            this.key = key;
        }

        public <V> Builder<K, V, T> messages(Converter<T, Collection<StreamMessage<K, V>>> messages) {
            return new Builder<K, V, T>(this.key, messages);
        }
    }
}

