/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.spring.batch.reader.PollableItemReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamSupport;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.support.AbstractItemStreamItemReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ErrorItemReader<T>
extends AbstractItemStreamItemReader<T>
implements PollableItemReader<T> {
    public static final float DEFAULT_ERROR_RATE = 0.5f;
    private final ItemReader<T> delegate;
    private final Supplier<Exception> exceptionSupplier;
    private float errorRate = 0.5f;
    private final AtomicLong currentItemCount = new AtomicLong();

    public ErrorItemReader(ItemReader<T> delegate) {
        this(delegate, () -> new TimeoutException("Simulated timeout"));
    }

    public ErrorItemReader(ItemReader<T> delegate, Supplier<Exception> exceptionSupplier) {
        this.setName(ClassUtils.getShortName(ErrorItemReader.class));
        this.delegate = delegate;
        this.exceptionSupplier = exceptionSupplier;
    }

    public void setName(String name) {
        if (this.delegate instanceof ItemStreamSupport) {
            ((ItemStreamSupport)this.delegate).setName(name + "-delegate");
        }
        super.setName(name);
    }

    public void setErrorRate(float rate) {
        Assert.isTrue((rate >= 0.0f && rate <= 1.0f ? 1 : 0) != 0, (String)"Rate must be between 0 and 1");
        this.errorRate = rate;
    }

    public T poll(long timeout, TimeUnit unit) {
        try {
            return this.read();
        }
        catch (Exception e) {
            throw new ItemStreamException((Throwable)e);
        }
    }

    public T read() throws UnexpectedInputException, ParseException, NonTransientResourceException, Exception {
        Object result = this.delegate.read();
        if (result != null && this.currentItemCount.getAndIncrement() % (long)Math.round(1.0f / this.errorRate) == 0L) {
            throw this.exceptionSupplier.get();
        }
        return (T)result;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).close();
        }
        super.close();
    }
}

