/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.gen.CollectionOptions;
import com.redis.spring.batch.gen.GeneratorItemReader;
import com.redis.spring.batch.gen.StreamOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

class GeneratorTests {
    GeneratorTests() {
    }

    @Test
    void defaults() throws UnexpectedInputException, ParseException, Exception {
        int count = 123;
        GeneratorItemReader reader = new GeneratorItemReader();
        reader.setMaxItemCount(count);
        List<KeyValue<String>> list = this.readAll(reader);
        Assertions.assertEquals((int)count, (int)list.size());
    }

    private List<KeyValue<String>> readAll(GeneratorItemReader reader) throws UnexpectedInputException, ParseException, Exception {
        KeyValue ds;
        ArrayList<KeyValue<String>> list = new ArrayList<KeyValue<String>>();
        while ((ds = (KeyValue)reader.read()) != null) {
            list.add((KeyValue<String>)ds);
        }
        return list;
    }

    @Test
    void options() throws Exception {
        int count = 123;
        GeneratorItemReader reader = new GeneratorItemReader();
        reader.setMaxItemCount(count);
        List<KeyValue<String>> list = this.readAll(reader);
        Assertions.assertEquals((int)count, (int)list.size());
        for (KeyValue<String> ds : list) {
            switch (ds.getType()) {
                case SET: 
                case LIST: 
                case ZSET: {
                    Assertions.assertEquals((int)CollectionOptions.DEFAULT_MEMBER_COUNT.getMax(), (int)((Collection)ds.getValue()).size());
                    break;
                }
                case STREAM: {
                    Assertions.assertEquals((int)StreamOptions.DEFAULT_MESSAGE_COUNT.getMax(), (int)((Collection)ds.getValue()).size());
                    break;
                }
            }
        }
    }

    @Test
    void keys() throws Exception {
        String lastKey;
        GeneratorItemReader reader = new GeneratorItemReader();
        reader.setMaxItemCount(10);
        reader.open(new ExecutionContext());
        KeyValue keyValue = (KeyValue)reader.read();
        Assertions.assertEquals((Object)("gen:" + GeneratorItemReader.DEFAULT_KEY_RANGE.getMin()), (Object)keyValue.getKey());
        do {
            lastKey = (String)keyValue.getKey();
        } while ((keyValue = (KeyValue)reader.read()) != null);
        Assertions.assertEquals((Object)"gen:10", (Object)lastKey);
    }

    @Test
    void read() throws Exception {
        int count = 456;
        GeneratorItemReader reader = new GeneratorItemReader();
        reader.open(new ExecutionContext());
        reader.setMaxItemCount(456);
        KeyValue ds1 = (KeyValue)reader.read();
        Assertions.assertEquals((Object)"gen:1", (Object)ds1.getKey());
        int actualCount = 1;
        while (reader.read() != null) {
            ++actualCount;
        }
        Assertions.assertEquals((int)count, (int)actualCount);
        reader.close();
    }
}

