/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redis.lettucemod.Beers;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.search.IndexInfo;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.DuplicatePolicy;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import com.redis.lettucemod.util.RedisModulesUtils;
import com.redis.spring.batch.RedisItemReader;
import com.redis.spring.batch.common.DataType;
import com.redis.spring.batch.common.KeyComparison;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.OperationValueReader;
import com.redis.spring.batch.common.ToSampleFunction;
import com.redis.spring.batch.common.ToSuggestionFunction;
import com.redis.spring.batch.gen.GeneratorItemReader;
import com.redis.spring.batch.gen.TimeSeriesOptions;
import com.redis.spring.batch.reader.KeyEvent;
import com.redis.spring.batch.reader.KeyspaceNotification;
import com.redis.spring.batch.reader.KeyspaceNotificationItemReader;
import com.redis.spring.batch.reader.StructItemReader;
import com.redis.spring.batch.test.LiveTests;
import com.redis.spring.batch.util.CodecUtils;
import com.redis.spring.batch.writer.BatchWriteOperation;
import com.redis.spring.batch.writer.OperationItemWriter;
import com.redis.spring.batch.writer.operation.JsonDel;
import com.redis.spring.batch.writer.operation.JsonSet;
import com.redis.spring.batch.writer.operation.Sugadd;
import com.redis.spring.batch.writer.operation.TsAdd;
import com.redis.spring.batch.writer.operation.TsAddAll;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.IteratorItemReader;
import org.springframework.batch.item.support.ListItemReader;

abstract class ModulesTests
extends LiveTests {
    private static final String JSON_BEER_1 = "[{\"id\":\"1\",\"brewery_id\":\"812\",\"name\":\"Hocus Pocus\",\"abv\":\"4.5\",\"ibu\":\"0\",\"srm\":\"0\",\"upc\":\"0\",\"filepath\":\"\",\"descript\":\"Our take on a classic summer ale.  A toast to weeds, rays, and summer haze.  A light, crisp ale for mowing lawns, hitting lazy fly balls, and communing with nature, Hocus Pocus is offered up as a summer sacrifice to clodless days.\\n\\nIts malty sweetness finishes tart and crisp and is best apprediated with a wedge of orange.\",\"add_user\":\"0\",\"last_mod\":\"2010-07-22 20:00:20 UTC\",\"style_name\":\"Light American Wheat Ale or Lager\",\"cat_name\":\"Other Style\"}]";
    private static final int BEER_COUNT = 1019;

    ModulesTests() {
    }

    @Override
    protected DataType[] generatorDataTypes() {
        return REDIS_MODULES_GENERATOR_TYPES;
    }

    @Test
    void readMetrics(TestInfo info) throws Exception {
        Metrics.globalRegistry.getMeters().forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
        SimpleMeterRegistry registry = new SimpleMeterRegistry(new SimpleConfig(){

            public String get(String key) {
                return null;
            }

            public Duration step() {
                return Duration.ofMillis(1L);
            }
        }, Clock.SYSTEM);
        Metrics.addRegistry((MeterRegistry)registry);
        this.generate(info);
        StructItemReader reader = RedisItemReader.struct((AbstractRedisClient)this.client);
        this.configureReader(info, (RedisItemReader<?, ?, ?>)reader);
        this.open((ItemStream)reader);
        Search search = registry.find("redis.batch.reader.queue.size");
        Assertions.assertNotNull((Object)search.gauge());
        reader.close();
        registry.close();
        Metrics.globalRegistry.getMeters().forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
    }

    @Test
    void readKeyspaceNotifications(TestInfo testInfo) throws Exception {
        KeyspaceNotification notification;
        this.enableKeyspaceNotifications(this.client);
        KeyspaceNotificationItemReader reader = new KeyspaceNotificationItemReader(this.client, (RedisCodec)CodecUtils.STRING_CODEC);
        reader.open(new ExecutionContext());
        GeneratorItemReader gen = this.generator(100);
        this.generate(testInfo, gen);
        this.awaitUntil(() -> reader.getQueue().size() > 0);
        Assertions.assertEquals((Object)KeyEvent.SET, (Object)((KeyspaceNotification)reader.getQueue().remove()).getEvent());
        LinkedHashSet<KeyEvent> eventTypes = new LinkedHashSet<KeyEvent>(Arrays.asList(KeyEvent.SET, KeyEvent.HSET, KeyEvent.JSON_SET, KeyEvent.RPUSH, KeyEvent.SADD, KeyEvent.ZADD, KeyEvent.XADD, KeyEvent.TS_ADD));
        while ((notification = (KeyspaceNotification)reader.getQueue().poll()) != null) {
            Assertions.assertTrue((boolean)eventTypes.contains(notification.getEvent()));
        }
        reader.close();
    }

    @Test
    void beerIndex() throws Exception {
        Beers.populateIndex((StatefulRedisModulesConnection)this.connection);
        IndexInfo indexInfo = RedisModulesUtils.indexInfo((List)this.commands.ftInfo((Object)"beers"));
        Assertions.assertEquals((double)1019.0, (Double)indexInfo.getNumDocs());
    }

    @Test
    void compareTimeseries(TestInfo info) throws Exception {
        int count = 1000;
        for (int index = 0; index < count; ++index) {
            this.commands.tsAdd((Object)("ts:" + index), Sample.of((double)123.0));
        }
        List<KeyComparison> comparisons = this.compare(info);
        Assertions.assertEquals((long)count, (long)comparisons.stream().filter(c -> c.getStatus() == KeyComparison.Status.MISSING).count());
    }

    @Test
    void readTimeseries() throws Exception {
        Sample[] samples;
        String key = "myts";
        for (Sample sample : samples = new Sample[]{Sample.of((long)System.currentTimeMillis(), (double)1.1), Sample.of((long)(System.currentTimeMillis() + 10L), (double)2.2)}) {
            this.commands.tsAdd((Object)key, sample);
        }
        OperationValueReader<String, String, String, KeyValue<String>> executor = this.structOperationExecutor();
        KeyValue ds = (KeyValue)executor.process(Arrays.asList(key)).get(0);
        Assertions.assertEquals((Object)key, (Object)ds.getKey());
        Assertions.assertEquals((Object)DataType.TIMESERIES, (Object)ds.getType());
        Assertions.assertEquals(Arrays.asList(samples), (Object)ds.getValue());
        executor.close();
    }

    @Test
    void readTimeseriesByteArray() throws Exception {
        Sample[] samples;
        String key = "myts";
        for (Sample sample : samples = new Sample[]{Sample.of((long)System.currentTimeMillis(), (double)1.1), Sample.of((long)(System.currentTimeMillis() + 10L), (double)2.2)}) {
            this.commands.tsAdd((Object)key, sample);
        }
        OperationValueReader executor = this.structOperationExecutor(ByteArrayCodec.INSTANCE);
        Function toByteArrayKeyFunction = CodecUtils.toByteArrayKeyFunction((RedisCodec)CodecUtils.STRING_CODEC);
        KeyValue ds = (KeyValue)executor.process(Arrays.asList(new byte[][]{(byte[])toByteArrayKeyFunction.apply(key)})).get(0);
        Assertions.assertArrayEquals((byte[])((byte[])toByteArrayKeyFunction.apply(key)), (byte[])((byte[])ds.getKey()));
        Assertions.assertEquals((Object)DataType.TIMESERIES, (Object)ds.getType());
        Assertions.assertEquals(Arrays.asList(samples), (Object)ds.getValue());
        executor.close();
    }

    @Test
    void writeSug(TestInfo testInfo) throws Exception {
        String key = "sugadd";
        ArrayList<Suggestion> values = new ArrayList<Suggestion>();
        for (int index = 0; index < 100; ++index) {
            values.add(Suggestion.string((Object)("word" + index)).score((double)(index + 1)).payload((Object)("payload" + index)).build());
        }
        ListItemReader reader = new ListItemReader(values);
        Sugadd sugadd = new Sugadd();
        sugadd.setKey((Object)key);
        sugadd.setSuggestionFunction((Function)new ToSuggestionFunction(Suggestion::getString, Suggestion::getScore, Suggestion::getPayload));
        OperationItemWriter writer = this.writer(sugadd);
        this.run(testInfo, reader, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((long)1L, (Long)this.commands.dbsize());
        Assertions.assertEquals((long)values.size(), (Long)this.commands.ftSuglen((Object)key));
    }

    @Test
    void writeSugIncr(TestInfo testInfo) throws Exception {
        String key = "sugaddIncr";
        ArrayList<Suggestion> values = new ArrayList<Suggestion>();
        for (int index = 0; index < 100; ++index) {
            values.add(Suggestion.string((Object)("word" + index)).score((double)(index + 1)).payload((Object)("payload" + index)).build());
        }
        ListItemReader reader = new ListItemReader(values);
        ToSuggestionFunction converter = new ToSuggestionFunction(Suggestion::getString, Suggestion::getScore, Suggestion::getPayload);
        Sugadd sugadd = new Sugadd();
        sugadd.setKey((Object)key);
        sugadd.setSuggestionFunction((Function)converter);
        sugadd.setIncr(true);
        OperationItemWriter writer = this.writer(sugadd);
        this.run(testInfo, reader, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((long)1L, (Long)this.commands.dbsize());
        Assertions.assertEquals((long)values.size(), (Long)this.commands.ftSuglen((Object)key));
    }

    @Test
    void writeTimeseries(TestInfo info) throws Exception {
        String key = "ts";
        HashMap<Long, Double> samples = new HashMap<Long, Double>();
        for (int index = 0; index < 100; ++index) {
            samples.put(Instant.now().toEpochMilli() + (long)index, Double.valueOf(index));
        }
        TsAdd tsAdd = new TsAdd();
        tsAdd.setKey((Object)key);
        tsAdd.setSampleFunction((Function)new ToSampleFunction(e -> (Long)e.getKey(), e -> (Double)e.getValue()));
        ListItemReader reader = new ListItemReader(new ArrayList(samples.entrySet()));
        OperationItemWriter writer = this.writer(tsAdd);
        this.run(info, reader, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((long)1L, (Long)this.commands.dbsize());
    }

    @Test
    void writeJsonSet(TestInfo testInfo) throws Exception {
        JsonSet jsonSet = new JsonSet();
        jsonSet.setKeyFunction(n -> "beer:" + n.get("id").asText());
        jsonSet.setValueFunction(JsonNode::toString);
        jsonSet.setPath(".");
        OperationItemWriter writer = this.writer(jsonSet);
        IteratorItemReader reader = new IteratorItemReader(Beers.jsonNodeIterator());
        this.run(testInfo, reader, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((int)1019, (int)this.commands.keys((Object)"beer:*").size());
        Assertions.assertEquals((Object)new ObjectMapper().readTree(JSON_BEER_1), (Object)new ObjectMapper().readTree((String)this.commands.jsonGet((Object)"beer:1", (Object[])new String[]{"$"})));
    }

    @Test
    void writeJsonDel(TestInfo testInfo) throws Exception {
        GeneratorItemReader gen = this.generator(DataType.JSON);
        this.generate(testInfo, gen);
        JsonDel jsonDel = new JsonDel();
        jsonDel.setKeyFunction(KeyValue::getKey);
        OperationItemWriter writer = this.writer(jsonDel);
        this.run(testInfo, gen, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((long)0L, (Long)this.commands.dbsize());
    }

    @Test
    void writeTsAdd(TestInfo testInfo) throws Exception {
        String key = "ts:1";
        Random random = new Random();
        int count = 100;
        ArrayList<Sample> samples = new ArrayList<Sample>(count);
        for (int index = 0; index < count; ++index) {
            long timestamp = System.currentTimeMillis() - (long)count + (long)(index % (count / 2));
            samples.add(Sample.of((long)timestamp, (double)random.nextDouble()));
        }
        ListItemReader reader = new ListItemReader(samples);
        AddOptions addOptions = ((AddOptions.Builder)AddOptions.builder().policy(DuplicatePolicy.LAST)).build();
        TsAdd tsadd = new TsAdd();
        tsadd.setKey((Object)key);
        tsadd.setSampleFunction(Function.identity());
        tsadd.setOptions(addOptions);
        OperationItemWriter writer = this.writer(tsadd);
        this.run(testInfo, reader, writer);
        this.awaitUntilFalse(() -> writer.isOpen());
        Assertions.assertEquals((float)(count / 2), (float)this.commands.tsRange((Object)key, TimeRange.unbounded(), RangeOptions.builder().build()).size(), (float)2.0f);
    }

    @Test
    void writeTsAddAll(TestInfo testInfo) throws Exception {
        int count = 10;
        GeneratorItemReader reader = this.generator(count, DataType.TIMESERIES);
        AddOptions addOptions = ((AddOptions.Builder)AddOptions.builder().policy(DuplicatePolicy.LAST)).build();
        TsAddAll tsadd = new TsAddAll();
        tsadd.setKeyFunction(KeyValue::getKey);
        tsadd.setSamplesFunction(t -> (Collection)t.getValue());
        tsadd.setOptions(addOptions);
        OperationItemWriter writer = new OperationItemWriter(this.client, (RedisCodec)CodecUtils.STRING_CODEC, (BatchWriteOperation)tsadd);
        this.run(testInfo, reader, writer);
        this.awaitUntilFalse(() -> ((OperationItemWriter)writer).isOpen());
        for (int index = 1; index <= count; ++index) {
            Assertions.assertEquals((float)TimeSeriesOptions.DEFAULT_SAMPLE_COUNT.getMin(), (float)this.commands.tsRange((Object)reader.key(index), TimeRange.unbounded(), RangeOptions.builder().build()).size(), (float)2.0f);
        }
    }
}

