/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.spring.batch.common.Range;
import com.redis.spring.batch.util.Predicates;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PredicatesTests {
    PredicatesTests() {
    }

    @Test
    void testOr() {
        Assertions.assertTrue((boolean)Predicates.or((Predicate[])new Predicate[0]).test(null));
        Assertions.assertFalse((boolean)Predicates.or((Predicate[])new Predicate[]{Predicates.isFalse()}).test(null));
        Assertions.assertTrue((boolean)Predicates.or((Predicate[])new Predicate[]{Predicates.isTrue()}).test(null));
        Assertions.assertTrue((boolean)Predicates.or((Predicate[])new Predicate[]{Predicates.isFalse(), Predicates.isTrue()}).test(null));
        Assertions.assertFalse((boolean)Predicates.or((Predicate[])new Predicate[]{Predicates.isFalse(), Predicates.isFalse()}).test(null));
    }

    @Test
    void testAnd() {
        Assertions.assertTrue((boolean)Predicates.and((Predicate[])new Predicate[0]).test(null));
        Assertions.assertFalse((boolean)Predicates.and((Predicate[])new Predicate[]{Predicates.isFalse()}).test(null));
        Assertions.assertTrue((boolean)Predicates.and((Predicate[])new Predicate[]{Predicates.isTrue()}).test(null));
        Assertions.assertTrue((boolean)Predicates.and((Predicate[])new Predicate[]{Predicates.isTrue(), Predicates.isTrue()}).test(null));
        Assertions.assertFalse((boolean)Predicates.and((Predicate[])new Predicate[]{Predicates.isFalse(), Predicates.isTrue()}).test(null));
    }

    @Test
    void include() {
        Predicate foo = Predicates.glob((String)"foo");
        Assertions.assertTrue((boolean)foo.test("foo"));
        Assertions.assertFalse((boolean)foo.test("bar"));
        Predicate fooStar = Predicates.glob((String)"foo*");
        Assertions.assertTrue((boolean)fooStar.test("foobar"));
        Assertions.assertFalse((boolean)fooStar.test("barfoo"));
    }

    @Test
    void exclude() {
        Predicate<String> foo = Predicates.glob((String)"foo").negate();
        Assertions.assertFalse((boolean)foo.test("foo"));
        Assertions.assertTrue((boolean)foo.test("foa"));
        Predicate<String> fooStar = Predicates.glob((String)"foo*").negate();
        Assertions.assertFalse((boolean)fooStar.test("foobar"));
        Assertions.assertTrue((boolean)fooStar.test("barfoo"));
    }

    @Test
    void includeAndExclude() {
        Predicate<String> foo1 = Predicates.glob((String)"foo1").and(Predicates.glob((String)"foo").negate());
        Assertions.assertFalse((boolean)foo1.test("foo"));
        Assertions.assertFalse((boolean)foo1.test("bar"));
        Assertions.assertTrue((boolean)foo1.test("foo1"));
        Predicate<String> foo1Star = Predicates.glob((String)"foo").and(Predicates.glob((String)"foo1*").negate());
        Assertions.assertTrue((boolean)foo1Star.test("foo"));
        Assertions.assertFalse((boolean)foo1Star.test("bar"));
        Assertions.assertFalse((boolean)foo1Star.test("foo1"));
    }

    @Test
    void slotExact() {
        Predicate predicate = Predicates.slots((Range[])new Range[]{Range.of((int)7638)});
        Assertions.assertTrue((boolean)predicate.test("abc"));
        Assertions.assertFalse((boolean)predicate.test("abcd"));
    }

    @Test
    void slotRange() {
        Predicate unbounded = Predicates.slots((Range[])new Range[]{Range.unbounded()});
        Assertions.assertTrue((boolean)unbounded.test("foo"));
        Assertions.assertTrue((boolean)unbounded.test("foo1"));
        Predicate is999999 = Predicates.slots((Range[])new Range[]{Range.of((int)999999)});
        Assertions.assertFalse((boolean)is999999.test("foo"));
    }

    @Test
    void kitchenSink() {
        Predicate<String> predicate = Predicates.glob((String)"foo").negate().and(Predicates.glob((String)"foo1")).and(Predicates.slots((Range[])new Range[]{Range.unbounded()}));
        Assertions.assertFalse((boolean)predicate.test("foo"));
        Assertions.assertFalse((boolean)predicate.test("bar"));
        Assertions.assertTrue((boolean)predicate.test("foo1"));
    }
}

