/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.spring.batch.common.Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RangeTests {
    RangeTests() {
    }

    @Test
    void parse() {
        this.assertRange(Range.of((String)":100"), 0, 100);
        this.assertRange(Range.of((String)"0:"), 0, Integer.MAX_VALUE);
        this.assertRange(Range.of((String)"0:*"), 0, Integer.MAX_VALUE);
        this.assertRange(Range.of((String)":*"), 0, Integer.MAX_VALUE);
        this.assertRange(Range.of((String)":"), 0, Integer.MAX_VALUE);
        this.assertRange(Range.of((String)"100"), 100, 100);
        this.assertRange(Range.of((String)"100"), 100, 100);
        this.assertRange(Range.of((String)"1234567890:1234567890"), 1234567890, 1234567890);
    }

    private void assertRange(Range range, int min, int max) {
        Assertions.assertEquals((int)min, (int)range.getMin());
        Assertions.assertEquals((int)max, (int)range.getMax());
    }
}

