/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.enterprise.Database;
import com.redis.enterprise.RedisModule;
import com.redis.testcontainers.RedisContainer;
import com.redis.testcontainers.RedisEnterpriseContainer;
import com.redis.testcontainers.RedisStackContainer;
import org.springframework.util.unit.DataSize;

public interface RedisContainerFactory {
    public static RedisStackContainer stack() {
        return new RedisStackContainer(RedisStackContainer.DEFAULT_IMAGE_NAME.withTag("latest"));
    }

    public static RedisEnterpriseContainer enterprise() {
        return new RedisEnterpriseContainer(RedisEnterpriseContainer.DEFAULT_IMAGE_NAME.withTag("latest")).withDatabase(Database.name((String)"BatchTests").memory(DataSize.ofMegabytes((long)70L)).ossCluster(true).modules(new RedisModule[]{RedisModule.JSON, RedisModule.TIMESERIES, RedisModule.SEARCH}).build());
    }

    public static RedisContainer redis(String tag) {
        return new RedisContainer(RedisContainer.DEFAULT_IMAGE_NAME.withTag(tag));
    }
}

