/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.test;

import com.redis.spring.batch.common.SetBlockingQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

class SetBlockingQueueTest {
    SetBlockingQueueTest() {
    }

    @Test
    void testQueueBounds() throws Exception {
        SetBlockingQueue bbq = new SetBlockingQueue(new LinkedBlockingQueue(), 5);
        bbq.put((Object)"one");
        bbq.put((Object)"two");
        bbq.put((Object)"three");
        bbq.put((Object)"four");
        bbq.put((Object)"five");
        Assert.assertEquals((long)5L, (long)bbq.size());
        Thread.currentThread().interrupt();
        try {
            bbq.put((Object)"even more dropped data");
        }
        catch (InterruptedException e) {
            Assert.assertEquals((long)5L, (long)bbq.size());
        }
        Assert.assertEquals((long)5L, (long)bbq.size());
    }

    @Test
    void testConcurrencyLargeQueue() throws Exception {
        this.testConcurrencyInternal(100, 10, 10, 60);
    }

    @Test
    void testConcurrencySmallQueue() throws Exception {
        this.testConcurrencyInternal(20, 10, 10, 60);
    }

    private void testConcurrencyInternal(int maxCapacity, int numInitialEntries, int entriesPerOperation, int maxTimeoutSeconds) throws Exception {
        SetBlockingQueue bbq = new SetBlockingQueue(new PriorityBlockingQueue(), maxCapacity);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (int i = 0; i < numInitialEntries; ++i) {
            bbq.add((Object)("initial " + i));
        }
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    try {
                        bbq.add((Object)("add " + i));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        --i;
                    }
                }
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    if (bbq.offer((Object)("offer " + i))) continue;
                    --i;
                }
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    if (bbq.offer((Object)("offer timeout " + i), 100L, TimeUnit.MILLISECONDS)) continue;
                    --i;
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    bbq.put((Object)("put " + i));
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    if (bbq.poll() != null) continue;
                    --i;
                }
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    if (bbq.poll(100L, TimeUnit.MILLISECONDS) != null) continue;
                    --i;
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    if (bbq.take() != null) continue;
                    --i;
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    String peek = (String)bbq.peek();
                    if (bbq.contains((Object)peek) && bbq.remove((Object)peek)) continue;
                    --i;
                }
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        runnables.add(() -> {
            int i = 0;
            try {
                for (i = 0; i < entriesPerOperation; ++i) {
                    int size = bbq.size();
                    Assert.assertTrue((size >= 0 && size <= maxCapacity ? 1 : 0) != 0);
                    int cap = bbq.remainingCapacity();
                    Assert.assertTrue((cap >= 0 && cap <= maxCapacity ? 1 : 0) != 0);
                }
            }
            finally {
                Assert.assertEquals((long)entriesPerOperation, (long)i);
            }
        });
        SetBlockingQueueTest.assertConcurrent("BoundedBlockingQueue concurrency test", runnables, maxTimeoutSeconds);
        Iterator iter = bbq.iterator();
        int numLeft = 0;
        while (iter.hasNext()) {
            iter.next();
            ++numLeft;
        }
        Assert.assertEquals((long)numInitialEntries, (long)numLeft);
        ArrayList drain = new ArrayList();
        bbq.drainTo(drain);
        Assert.assertEquals((long)numInitialEntries, (long)drain.size());
        Assert.assertEquals((long)0L, (long)bbq.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertConcurrent(String message, List<? extends Runnable> runnables, int maxTimeoutSeconds) throws InterruptedException {
        int numThreads = runnables.size();
        List exceptions = Collections.synchronizedList(new ArrayList());
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        try {
            CountDownLatch allExecutorThreadsReady = new CountDownLatch(numThreads);
            CountDownLatch afterInitBlocker = new CountDownLatch(1);
            CountDownLatch allDone = new CountDownLatch(numThreads);
            for (Runnable runnable : runnables) {
                threadPool.submit(() -> {
                    allExecutorThreadsReady.countDown();
                    try {
                        afterInitBlocker.await();
                        submittedTestRunnable.run();
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                    finally {
                        allDone.countDown();
                    }
                });
            }
            Assert.assertTrue((String)"Timeout initializing threads! Perform long lasting initializations before passing runnables to assertConcurrent", (boolean)allExecutorThreadsReady.await(runnables.size() * 10, TimeUnit.MILLISECONDS));
            afterInitBlocker.countDown();
            Assert.assertTrue((String)(message + " timeout! More than" + maxTimeoutSeconds + "seconds"), (boolean)allDone.await(maxTimeoutSeconds, TimeUnit.SECONDS));
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)(message + " failed with exception(s)" + String.valueOf(exceptions)), (boolean)exceptions.isEmpty());
    }
}

