/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch;

import com.redis.spring.batch.util.CodecUtils;
import com.redis.spring.batch.writer.AbstractOperationItemWriter;
import com.redis.spring.batch.writer.BatchWriteOperation;
import com.redis.spring.batch.writer.DumpItemWriter;
import com.redis.spring.batch.writer.OperationItemWriter;
import com.redis.spring.batch.writer.StructItemWriter;
import com.redis.spring.batch.writer.WriteOperation;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.codec.RedisCodec;

public abstract class RedisItemWriter<K, V, T>
extends AbstractOperationItemWriter<K, V, T> {
    protected RedisItemWriter(AbstractRedisClient client, RedisCodec<K, V> codec) {
        super(client, codec);
    }

    public static StructItemWriter<String, String> struct(AbstractRedisClient client) {
        return RedisItemWriter.struct(client, CodecUtils.STRING_CODEC);
    }

    public static <K, V> StructItemWriter<K, V> struct(AbstractRedisClient client, RedisCodec<K, V> codec) {
        return new StructItemWriter<K, V>(client, codec);
    }

    public static DumpItemWriter dump(AbstractRedisClient client) {
        return new DumpItemWriter(client);
    }

    public static <T> OperationItemWriter<String, String, T> operation(AbstractRedisClient client, WriteOperation<String, String, T> operation) {
        return RedisItemWriter.operation(client, CodecUtils.STRING_CODEC, operation);
    }

    public static <K, V, T> OperationItemWriter<K, V, T> operation(AbstractRedisClient client, RedisCodec<K, V> codec, WriteOperation<K, V, T> operation) {
        return new OperationItemWriter<K, V, T>(client, codec, operation);
    }

    public static <T> OperationItemWriter<String, String, T> operation(AbstractRedisClient client, BatchWriteOperation<String, String, T> operation) {
        return RedisItemWriter.operation(client, CodecUtils.STRING_CODEC, operation);
    }

    public static <K, V, T> OperationItemWriter<K, V, T> operation(AbstractRedisClient client, RedisCodec<K, V> codec, BatchWriteOperation<K, V, T> operation) {
        return new OperationItemWriter<K, V, T>(client, codec, operation);
    }
}

