/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataType {
    NONE("none"),
    HASH("hash"),
    JSON("ReJSON-RL"),
    LIST("list"),
    SET("set"),
    STREAM("stream"),
    STRING("string"),
    TIMESERIES("TSDB-TYPE"),
    ZSET("zset");

    private static final Map<String, DataType> TYPE_MAP;
    private final String string;

    private DataType(String string2) {
        this.string = string2;
    }

    public String getString() {
        return this.string;
    }

    public static DataType of(String string) {
        return TYPE_MAP.getOrDefault(string.toLowerCase(), NONE);
    }

    static {
        TYPE_MAP = Stream.of(DataType.values()).collect(Collectors.toMap(t -> t.getString().toLowerCase(), Function.identity()));
    }
}

