/*
 * Decompiled with CFR 0.152.
 */
package com.redis.spring.batch.common;

import com.redis.spring.batch.RedisItemReader;
import com.redis.spring.batch.common.KeyComparison;
import com.redis.spring.batch.common.KeyValue;
import com.redis.spring.batch.common.OperationValueReader;
import com.redis.spring.batch.reader.KeyComparisonValueReader;
import com.redis.spring.batch.reader.KeyValueItemReader;
import com.redis.spring.batch.util.CodecUtils;
import java.time.Duration;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStreamSupport;
import org.springframework.batch.item.support.PassThroughItemProcessor;

public class KeyComparisonItemReader
extends RedisItemReader<String, String, KeyComparison> {
    private Duration ttlTolerance = KeyComparisonValueReader.DEFAULT_TTL_TOLERANCE;
    private final OperationValueReader<String, String, String, KeyValue<String>> source;
    private final ItemProcessor<String, String> sourceKeyProcessor;
    private final OperationValueReader<String, String, String, KeyValue<String>> target;
    private ItemProcessor<KeyValue<String>, KeyValue<String>> processor = new PassThroughItemProcessor();
    private boolean compareStreamMessageIds;

    public KeyComparisonItemReader(KeyValueItemReader<String, String> source, KeyValueItemReader<String, String> target) {
        super(source.getClient(), CodecUtils.STRING_CODEC);
        this.source = source.operationValueReader();
        this.sourceKeyProcessor = source.getKeyProcessor();
        this.target = target.operationValueReader();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.source != null) {
            this.source.setName(name + "-source");
        }
        if (this.processor instanceof ItemStreamSupport) {
            ((ItemStreamSupport)this.processor).setName(name + "-processor");
        }
        if (this.target != null) {
            this.target.setName(name + "-target");
        }
    }

    public void setCompareStreamMessageIds(boolean enable) {
        this.compareStreamMessageIds = enable;
    }

    public void setProcessor(ItemProcessor<KeyValue<String>, KeyValue<String>> processor) {
        this.processor = processor;
    }

    public void setTtlTolerance(Duration ttlTolerance) {
        this.ttlTolerance = ttlTolerance;
    }

    public KeyComparisonValueReader valueReader() {
        KeyComparisonValueReader valueReader = new KeyComparisonValueReader(this.source, this.target);
        valueReader.setCompareStreamMessageIds(this.compareStreamMessageIds);
        valueReader.setKeyProcessor(this.sourceKeyProcessor);
        valueReader.setProcessor(this.processor);
        valueReader.setTtlTolerance(this.ttlTolerance);
        return valueReader;
    }
}

